/** Table of Decaf symbols.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include "symboltable.h"
#include "util.h"
#include <stdio.h>
#include <string.h>


/** Clears this symbol table. */
void
clear_symboltable( SymbolTable* table)
{
	clear_dictionary( &table->dictionary);
	memset( table->symbols, 0, sizeof table->symbols);
}


/** Adds this symbol to the symbol table. */
void
add_symbol( SymbolTable* table, const char* name, int block, int type)
{
	int i = find( &table->dictionary, name);
	Symbol* symbol = &table->symbols[i];
	if( i == 0) {
		i = insert( &table->dictionary, name);
		assumex( i < SYMBOLS, "too many symbols");
		symbol = &table->symbols[i];
		clear_stack( &symbol->type);
		symbol->block = 0;
	}
	if( symbol->block == block)
		printf( "symbol %s is previously defined\n", name);
	push( &symbol->type, type);
	symbol->block = block;
	symbol->count = 0;
}


/** Removes this symbol from the symbol table. */
void
remove_symbol( SymbolTable* table, const char* name)
{
	int i = find( &table->dictionary, name);
	assumex( i > 0, "unknown symbol %s", name);
	pop( &table->symbols[i].type, 1);
}


/** Looks up this symbol in the symbol table. */
Symbol*
find_symbol( SymbolTable* table, const char* name)
{
	int i = find( &table->dictionary, name);
	if( i == 0 || table->symbols[i].type.count == 0) {
		printf( "symbol %s is undefined\n", name);
		return NULL;
	} else
		return &table->symbols[i];
}
