/* DChub - a Direct Connect Hub for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * toolkit.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: toolkit.h,v 1.1 2003/05/31 13:50:57 ericprev Exp $
*/

#ifndef __TOOLKIT_H__
#define __TOOLKIT_H__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


/******************************************************************/
/* copy the source string into the dest string (upto max_byte-1). */
/* The dest string is always \0 terminated                        */
/******************************************************************/
void strncpy_max(char *destination, const char *source, unsigned int max_byte);

/******************************************************************/
/* adjust the given 'var' to be sure it is always <= to 'max_val' */
/******************************************************************/
#define CLAMP_VAL(var,max_val)		{if((var)>(max_val)) (var)=(max_val);}

/***************************************************/
/* compute the size of a NULL terminated ptr array */
/***************************************************/
int size_of_null_array(void **array);

/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/* ----------------------- memory access macro ------------------------------ */
/* -------------------------------------------------------------------------- */
/* -------------------------------------------------------------------------- */
/*****************************************************************************/
/* some CPU accepts to read word not aligned on a word boundary, other don't */
/*****************************************************************************/
#ifndef NO_UNALIGNED_ACCESS
/* lucky, the CPU is not too stupid */

#define GET_UAA_GUINT16(addr)		(*((guint16*)(addr)))
#define GET_UAA_GUINT32(addr)		(*((guint32*)(addr)))
#define GET_UAA_GUINT64(addr)		(*((guint64*)(addr)))

#define GET_UAA_GINT16(addr)		(*((gint16*)(addr)))
#define GET_UAA_GINT32(addr)		(*((gint32*)(addr)))

#else
/* bad luck, the CPU is very stupid */
guint16 get_unaligned_guint16(guint8 *addr);
guint32 get_unaligned_guint32(guint8 *addr);
guint64 get_unaligned_guint64(guint8 *addr);

#define GET_UAA_GUINT16(addr)		get_unaligned_guint16(addr)
#define GET_UAA_GUINT32(addr)		get_unaligned_guint32(addr)
#define GET_UAA_GUINT64(addr)		get_unaligned_guint64(addr)

/* it is not an error, we use the same function as above */
#define GET_UAA_GINT16(addr)		((gint16)get_unaligned_guint16(addr))
#define GET_UAA_GINT32(addr)		((gint32)get_unaligned_guint32(addr))
#endif

#endif
