/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * done_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: done_clist.c,v 1.5 2004/01/13 17:05:51 ericprev Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <db.h>
#include <sys/types.h>
#include <limits.h>
#include <dirent.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "done_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "init_fnc.h"
#include "misc.h"
#include "graph.h"

/********************************************/
/* load the .done file list into done_clist */
/****************************************************************/
/* if with_clear==TRUE, the gtk_list is emptied before using it */
/****************************************************************/
static void load_done_xfer(char *fname,gboolean with_clear)
{
	GtkWidget *w;
	FILE *f;
	char buf[51200];
	GtkTreeModel *gtm;
	GtkListStore *gls;
	GtkTreeIter iter;
	char *entry_type[]={	_("xDL"),		/* type 0=XDL */
								_("Bittorrent"),
								_("xUL")
								};

	/* the 6 following variables must be static because their values are shared among all list */
	static guint64 dled_size=0;
	static unsigned long long min_time=ULONG_MAX;
	static unsigned long long max_time=0;

	static guint64 ul_dled_size=0;
	static unsigned long long ul_min_time=ULONG_MAX;
	static unsigned long long ul_max_time=0;

	GtkTreeModel *ul_gtm;
	GtkListStore *ul_gls;

	w=get_widget_by_widget_name(main_window,"done_clist");
	gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));

	w=get_widget_by_widget_name(main_window,"ul_done_treeview");
	ul_gls=GTK_LIST_STORE(ul_gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));

	if(with_clear==TRUE)
	{
		gtk_list_store_clear(gls);
		gtk_list_store_clear(ul_gls);

		dled_size=0;
		min_time=ULONG_MAX;
		max_time=0;

		ul_dled_size=0;
		ul_min_time=ULONG_MAX;
		ul_max_time=0;
	}

	f=fopen(fname,"rb");
	if(f==NULL)
		return;

	while(fgets(buf,sizeof(buf),f)!=NULL)
	{
		char *t;
		int type=0;

		t=strrchr(buf,'\n');
		if(t!=NULL)
			*t='\0';

		/* DL string format is: nick|XDL[:end_time]|local_fic|filesize */
		/*                  or: nick|BitTorrent[:end_time]|local_fic|filesize */
		/* UL string format is: nick|XUL:end_time:start_time:start_pos:byte_sent:end_code|local_fic|filesize */

		/* maybe a |XDL[:end_time] */
		t=strstr(buf,"|XDL");
		if(t==NULL)
		{
			/* not a |XDL[:end_time] maybe a |BitTorrent[:end_time] */
			t=strstr(buf,"|BitTorrent");
			type=1;
			if(t==NULL)
			{
				t=strstr(buf,"|XUL");
				type=2;
			}
		}

		if(t!=NULL)
		{
			gchar **fields;

			fields=g_strsplit(buf,"|",0);
			if(size_of_null_array((void**)fields)==4)
			{
				switch(type)
				{
					case 0:
					case 1:
								{
									guint64 size_as_val;
									char buf_size[64];
									char *end_date=NULL;
									gulong end_time;
									char formatted_end_time[128];
				
							/* DL string format is: nick|XDL[:end_time]|local_fic|filesize */
							/*                  or: nick|BitTorrent[:end_time]|local_fic|filesize */

									sscanf(fields[3],"%llu",&size_as_val);
				
									dled_size+=size_as_val;
#ifndef NO_PRINTF_LOCALE
									sprintf(buf_size,"%'llu",size_as_val);  /* NO_PRINTF_LOCAL support added */
#else
									sprintf(buf_size,"%llu",size_as_val);
#endif
									end_date=strchr(fields[1],':');		/* check if the format type contains an end date */
									if(end_date==NULL)
									{
										end_time=0;
										formatted_end_time[0]='\0';
									}
									else
									{
										time_t fi_time;
										unsigned long long e_time;
										sscanf(end_date+1,"%llu",&e_time);
										end_time=e_time;
										fi_time=end_time;
										strftime(formatted_end_time,sizeof(formatted_end_time)-1,"%b %d %H:%M",localtime(&fi_time));
				
										if(max_time<e_time)
											max_time=e_time;
										if(min_time>e_time)
											min_time=e_time;
									}
				
									gtk_list_store_append(gls,&iter);
									{
										gchar *utf8_2;
				
										utf8_2=g_locale_to_utf8(fields[2],-1,NULL,NULL,NULL);
										gtk_list_store_set(gls,&iter, DOC_FNAME_COL,entry_type[type],			/* remote filename */
																				DOC_END_TIME,formatted_end_time,
																				DOC_SIZE_COL,buf_size,
																				DOC_SIZE_AS_VAL,size_as_val,		/* local filesize */
																				DOC_LFNAME_COL,utf8_2,		/* local filename */
																				DOC_END_TIME_AS_VAL,end_time,
																				-1);
				
										g_free(utf8_2);
				
										graph_stat_add(end_time,size_as_val, XFER_IS_DL);
									}
								}
								break;

					case 2:
								{
									char buf_size[64];
									guint64 end_time=0;
									char formatted_end_time[128];
									char end_code=' ';
									guint64 size_as_val=0;

									/* UL string format is: nick|XUL:end_time:start_time:start_pos:byte_sent:end_code|local_fic|filesize */
				
									sscanf(fields[1],"XUL:%llu:%*u:%*u:%llu:%c",&end_time,&size_as_val,&end_code);

									ul_dled_size+=size_as_val;
#ifndef NO_PRINTF_LOCALE
									sprintf(buf_size,"%'llu",size_as_val);  /* NO_PRINTF_LOCAL support added */
#else
									sprintf(buf_size,"%llu",size_as_val);
#endif
									{
										time_t fi_time;

										fi_time=end_time;
										strftime(formatted_end_time,sizeof(formatted_end_time)-1,"%b %d %H:%M",localtime(&fi_time));
				
										if(ul_max_time<end_time)
											ul_max_time=end_time;
										if(ul_min_time>end_time)
											ul_min_time=end_time;
									}
				
									gtk_list_store_append(ul_gls,&iter);
									{
										gchar *utf8_0, *utf8_2;
				
										utf8_0=g_locale_to_utf8(fields[0],-1,NULL,NULL,NULL);
										utf8_2=g_locale_to_utf8(fields[2],-1,NULL,NULL,NULL);
										gtk_list_store_set(ul_gls,&iter, UDT_NICK_COL,utf8_0,			/* remote filename */
																				UDT_END_TIME,formatted_end_time,
																				UDT_XFER_SIZE_COL,buf_size,
																				UDT_XFER_SIZE_AS_VAL,size_as_val,		/* #bytes transfered */
																				UDT_LFNAME_COL,utf8_2,		/* local filename */
																				UDT_END_TIME_AS_VAL,(unsigned long)end_time,
																				-1);
				
										g_free(utf8_0);
										g_free(utf8_2);
				
										graph_stat_add(end_time,size_as_val, XFER_IS_UL);
									}
								}
								break;
				}
			}
			g_strfreev(fields);
		}
	}

	/* DL speed computation */
	{
		GtkWidget *w;

		/* update the average speed */
		w=get_widget_by_widget_name(main_window,"dl_speed_stat");
		if((dled_size==0)||(min_time==ULONG_MAX)||(max_time==0)||(min_time==max_time))
			gtk_label_set(GTK_LABEL(w),_("0 KB/s"));
		else
		{
			sprintf(buf,_("%.2f KB/s"),(((double)dled_size)/1024)/(max_time-min_time));
			gtk_label_set(GTK_LABEL(w),buf);
		}

		/* update the downloaded size */
		w=get_widget_by_widget_name(main_window,"dl_size_stat");
		if(dled_size==0)
			gtk_label_set(GTK_LABEL(w),"0B");
		else
		{
			GString *str;

			str=value_to_readable(dled_size,1024);
			g_string_append_c(str,'B');
			gtk_label_set(GTK_LABEL(w),str->str);
			g_string_free(str,TRUE);
		}

		/* update the download duration */
		w=get_widget_by_widget_name(main_window,"dl_time_stat");
		if((min_time==ULONG_MAX)||(max_time==0)||(min_time==max_time))
			gtk_label_set(GTK_LABEL(w),"in 0\"");
		else
		{
			GString *str;

			str=duration_to_readable(max_time-min_time);
			g_string_prepend(str,_("in "));
			gtk_label_set(GTK_LABEL(w),str->str);
			g_string_free(str,TRUE);
		}
	}

	/* UL speed computation */
	{
		GtkWidget *w;

		/* update the average speed */
		w=get_widget_by_widget_name(main_window,"ul_speed_stat");
		if((ul_dled_size==0)||(ul_min_time==ULONG_MAX)||(ul_max_time==0)||(ul_min_time==ul_max_time))
			gtk_label_set(GTK_LABEL(w),_("0 KB/s"));
		else
		{
			sprintf(buf,_("%.2f KB/s"),(((double)ul_dled_size)/1024)/(ul_max_time-ul_min_time));
			gtk_label_set(GTK_LABEL(w),buf);
		}

		/* update the downloaded size */
		w=get_widget_by_widget_name(main_window,"ul_size_stat");
		if(ul_dled_size==0)
			gtk_label_set(GTK_LABEL(w),"0B");
		else
		{
			GString *str;

			str=value_to_readable(ul_dled_size,1024);
			g_string_append_c(str,'B');
			gtk_label_set(GTK_LABEL(w),str->str);
			g_string_free(str,TRUE);
		}

		/* update the download duration */
		w=get_widget_by_widget_name(main_window,"ul_time_stat");
		if((ul_min_time==ULONG_MAX)||(ul_max_time==0)||(ul_min_time==ul_max_time))
			gtk_label_set(GTK_LABEL(w),"in 0\"");
		else
		{
			GString *str;

			str=duration_to_readable(ul_max_time-ul_min_time);
			g_string_prepend(str,_("in "));
			gtk_label_set(GTK_LABEL(w),str->str);
			g_string_free(str,TRUE);
		}
	}
	fclose(f);
}

/*******************************************************************************************/
/* load done+exited file and all *.done files from $HOME/.dctc/running into the done_clist */
/*******************************************************************************************/
void load_all_done_lists(void)
{
	GString *str;

	graph_stat_clear();

	/* 1) load the done+exited list */
	str=g_string_new(dctc_dir->str);
	g_string_append(str,"/done+exited");
	load_done_xfer(str->str,TRUE);
	
	/* 2) load all the .done list */
	{
		DIR *dir;

		dir=opendir(dctc_dir->str);
		if(dir!=NULL)
		{
			struct dirent *obj;
			int base_len;

			g_string_assign(str,dctc_dir->str);
			g_string_append_c(str,'/');
			base_len=str->len;

			while((obj=readdir(dir))!=NULL)
			{
				int fname_len;

				if(obj->d_name[0]=='.')
					continue;

				fname_len=strlen(obj->d_name);
				if(fname_len<5)
					continue;

				if(strcmp(obj->d_name+fname_len-5,".done"))
					continue;

				/* here, we only have .done files */
				g_string_truncate(str,base_len);
				g_string_append(str,obj->d_name);
				load_done_xfer(str->str,FALSE);
			}
		}
	}

	/* 3) load bittorrent done file */
	g_string_sprintf(str,"%s/bt.done",bt2dc_gui2_directory->str);
	load_done_xfer(str->str,FALSE);
		
	g_string_free(str,TRUE);
}

/*************************************************************************/
/* delete done+exited file and all *.done files from $HOME/.dctc/running */
/*************************************************************************/
void delete_all_done_lists(void)
{
	GString *str;

	/* erase the global list */
	str=g_string_new(dctc_dir->str);
	g_string_sprintfa(str,"/done+exited");
	unlink(str->str);

	/* erase all .done list */
	{
		DIR *dir;

		dir=opendir(dctc_dir->str);
		if(dir!=NULL)
		{
			struct dirent *obj;
			int base_len;

			g_string_assign(str,dctc_dir->str);
			g_string_append_c(str,'/');
			base_len=str->len;

			while((obj=readdir(dir))!=NULL)
			{
				int fname_len;

				if(obj->d_name[0]=='.')
					continue;

				fname_len=strlen(obj->d_name);
				if(fname_len<5)
					continue;

				if(strcmp(obj->d_name+fname_len-5,".done"))
					continue;

				/* here, we only have .done files */
				g_string_truncate(str,base_len);
				g_string_append(str,obj->d_name);
				unlink(str->str);
			}
		}
	}

	/* and unlink bittorrent .done file */
	g_string_sprintf(str,"%s/bt.done",bt2dc_gui2_directory->str);
	unlink(str->str);

	g_string_free(str,TRUE);
}

/********************************************/
/* build modele and view for the done clist */
/********************************************/
void bmav4_done_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_DOC_COL,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_UINT64,G_TYPE_ULONG);

	view=get_widget_by_widget_name(main_window,"done_clist");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);
	
	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),DOC_FNAME_COL,_("Xfer type"),rend,"text",DOC_FNAME_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),DOC_END_TIME,DOC_END_TIME_AS_VAL,_("end xfer time"),rend,"text",DOC_END_TIME,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	g_object_set(rend,"xalign",(gfloat)1.0,NULL);
	MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),DOC_SIZE_COL,DOC_SIZE_AS_VAL,_("Size"),rend,"text",DOC_SIZE_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),DOC_LFNAME_COL,_("Local Filename"),rend,"text",DOC_LFNAME_COL,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}

/***********************************************/
/* build modele and view for the UL done clist */
/***********************************************/
void bmav4_ul_done_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_UDT_COL,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_UINT64,G_TYPE_ULONG);

	view=get_widget_by_widget_name(main_window,"ul_done_treeview");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);
	
	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UDT_NICK_COL,_("Nick"),rend,"text",UDT_NICK_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UDT_END_TIME,DOC_END_TIME_AS_VAL,_("end xfer time"),rend,"text",UDT_END_TIME,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	g_object_set(rend,"xalign",(gfloat)1.0,NULL);
	MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UDT_XFER_SIZE_COL,DOC_SIZE_AS_VAL,_("Transfered Bytes"),rend,"text",UDT_XFER_SIZE_COL,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),UDT_LFNAME_COL,_("Local Filename"),rend,"text",UDT_LFNAME_COL,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}

