
/* darkstat: a network traffic analyzer
 * (c) 2001-2003, Emil Mikulic.
 */

#include "bignum.h"
#include <stdio.h>
#include <stdlib.h>



#ifndef HAVE_64PRINT_COMMAS



#ifdef HAVE_64PRINT

/* note: output needs to be deallocated */
char *strint64(const int64 i)
{
	char *tmp, buf[21]; /* strlen("18446744073709551616") + 1 */
	int len, j, pos;

	len = sprintf(buf, "%" LONGLONG_FORMAT "u", i);
	tmp = (char*)malloc(len + (len-1)/3 + 1);

	pos = 0;
	for (j=0; j<len; j++)
	{
		tmp[j+pos] = buf[j];
		if ((len-j-1) % 3 == 0 && (len-j-1) != 0)
		{
			pos++;
			tmp[j+pos] = ',';
		}
	}
        tmp[j+pos] = 0;

	return tmp;
}

#else /* not HAVE_64PRINT */

/* note: output needs to be deallocated */
char *strint64(const int64 i)
{
	int64 x = i;
	char *tmp, buf[21]; /* strlen("18446744073709551616") + 1 */
	int j, pos, digits = 0;

	const dword last_digit[] = {
		0, /* 2^32 * 0 */
		6, /* 2^32 * 1 */
		2, /* 2^32 * 2 */
		8, /* 2^32 * 3 */
		4  /* 2^32 * 4 */
	};	   /* loop after that */

	const dword leftover[] = {
		0,           /* 2^32*0/10 */
		429496729U,  /* 2^32*1/10 */
		858993459U,  /* 2^32*2/10 */
		1288490188U, /* 2^32*3/10 */
		1717986918U, /* 2^32*4/10 */
		2147483648U, /* 2^32*5/10 */
		2576980377U, /* 2^32*6/10 */
		3006477107U, /* 2^32*7/10 */
		3435973836U, /* 2^32*8/10 */
		3865470566U  /* 2^32*9/10 */
	};

	do
	{
		dword last, left;

#ifdef HAVE_64MATH
		last = x % 10;
#else
		/* last digit increment due to HI */
		last = last_digit[x.hi % 5];

		/* add last digit of LO */
		last += x.lo % 10;
#endif

		/* in the buffer */
		buf[digits] = (char)((last % 10) + '0');
		digits++;

		/* divide x by 10 */
		left = leftover[HI(x) % 10];
		if (last > 9) left++; /* this part would be fractional */
#ifdef HAVE_64MATH
		x /= 10;
#else
		x.hi /= 10;
		x.lo /= 10;
#endif
		i64add32(x, left);
	}
#ifdef HAVE_64MATH
	while (x);
#else
	while (x.hi || x.lo);
#endif

	/* digits + commas + null */
	tmp = (char*)malloc(digits + (digits-1)/3 + 1);

	/* reverse buf and add commas */
	pos = 0; /* pos in buf[] */
	j = 0;   /* pos in tmp */

	for (pos=digits-1; pos>=0; pos--)
	{
		tmp[j++] = buf[pos];
		if (pos % 3 == 0 && pos != 0) tmp[j++] = ',';
	}
	tmp[j] = 0; /* null */

	return tmp;
}

#endif /* HAVE_64PRINT */



/* note: output needs to be deallocated */
char *strint32(const dword i)
{
	char *tmp, buf[11]; /* strlen("4294967296") + 1 */
	int len, j, pos;

	len = sprintf(buf, "%u", i);
	tmp = (char*)malloc(len + (len-1)/3 + 1);

	pos = 0;
	for (j=0; j<len; j++)
	{
		tmp[j+pos] = buf[j];
		if ((len-j-1) % 3 == 0 && (len-j-1) != 0)
		{
			pos++;
			tmp[j+pos] = ',';
		}
	}
        tmp[j+pos] = 0;

	return tmp;
}



#endif /* HAVE_64PRINT_COMMAS */

