#!/usr/bin/env perl

# Some tests for 'darcs pull', with many files

use lib 'lib/perl';
use Test::More 'no_plan';
use Test::Darcs;
use Shell::Command;
use strict;

# We need to find GNU tar first (it's for example `gtar' on SunOS)
my $tarcmd = "";
for my $cmd ('tar', 'gtar') {
    my $ver = `/bin/sh -c "${cmd} --version 2>&1"`;
    if (index(${ver}, "GNU") >= 0) {
        $tarcmd = ${cmd};
    }
}

if (${tarcmd} eq "") {
    die ("Cannot find GNU tar");
}

for my $format ('--old-fashioned-inventory','--hashed','--darcs-2') {
    ok( (chdir 'repos'), "$format: chdir repos");

    # This tar call could be replaced by pure Perl for portability, but it would mean shipping several more Perl modules.
    `${tarcmd} -xzf many-files${format}.tgz`;
    chdir '../';
    init_tmp_repo($format);

    like( darcs("pull -a ../repos/many-files${format}"),
        qr/Finished pulling/,
        "$format: pull works on many patches at a time" );

    # put things back how we found them.
    chdir '../';
    `ls -l repos/many-files${format}`;
    rm_rf "repos/many-files${format}";
}


