module Main where

import IO
import System

main :: IO ()
main = do [varname] <- getArgs
          thedata <- hGetContents stdin
          putStr $ "static const char " ++ varname ++ "_value[] =\n \""
          putStr $ concatMap c2s thedata
          putStr "\";\n"
          putStr $ "char *" ++ varname ++ "(void) {\n" ++
                     "  return (char *) "++varname++"_value;\n}\n"
    where c2s '\n' = "\\n\"\n \""
          c2s '\\' = "\\\\"
          c2s '\t' = "\\t"
          c2s '\r' = "\\r"
          c2s '"'  = "\\\""
          c2s c = [c]
