/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include <iostream>
#include "OverwriteDlg.hh"

BEGIN_EVENT_TABLE (OverwriteDlg, wxDialog)
    EVT_BUTTON( ODL_ALL_ID , OverwriteDlg::buttonClicked )
    EVT_BUTTON( wxID_YES , OverwriteDlg::buttonClicked )
    EVT_BUTTON( wxID_NO , OverwriteDlg::buttonClicked )
END_EVENT_TABLE()   

    
    
OverwriteDlg::OverwriteDlg(wxWindow *parent, 
			   wxWindowID id, 
			   const wxString &label,
			   const wxPoint &pos, 
			   const wxSize &size, 
			   long style): wxDialog (parent, 
						  id,
						  _("Question"), 
						  pos, 
						  size ,
						  style) 
						  
    
{
    
    wxBoxSizer *mainSizer = new wxBoxSizer(wxVERTICAL);
    wxBoxSizer *btnSizer = new wxBoxSizer(wxHORIZONTAL);

    wxString msg = _("The destination file already exists!");
    msg += _T("\n");
    msg +=  _("Do you want to overwrite");
    msg += label; 
    msg += _("? ");
    wxStaticText *message = new wxStaticText(this, -1 , msg );

    wxButton *yesBtn = new wxButton( this , wxID_YES , _("Yes"));
    wxButton *noBtn = new wxButton( this , wxID_NO , _("No"));
    wxButton *allBtn = new wxButton( this , ODL_ALL_ID , _("Always overwrite"));
    


    btnSizer->Add( yesBtn , 1 , wxEXPAND | wxALIGN_LEFT | wxALL , 5);
    btnSizer->Add( noBtn ,  1 , wxEXPAND | wxALIGN_CENTER_HORIZONTAL | wxALL , 5);
    btnSizer->Add( allBtn , 1 , wxEXPAND | wxALIGN_RIGHT | wxALL , 5);

    
    mainSizer->Add( message ,1 , wxCENTER | wxALL , 20);
    mainSizer->Add( btnSizer , 0 , wxEXPAND | wxCENTER | wxALL , 5);
    
    mainSizer->Fit(this);
    SetSizer(mainSizer);
    Center();

}


OverwriteDlg::~OverwriteDlg(){}

void OverwriteDlg::buttonClicked( wxCommandEvent &event ){
    EndModal( event.GetId() );
}
