/***************************************************************************
 *   Copyright (C) 2004 by Armand                                          *
 *   armand@blackbox                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "Erreur.hh"

Erreur::Erreur(wxWindow* parent, const wxString& caption)
 : Cryptonit::P11Error(), parentwindow(parent), dlgCaption(caption)
{
	dlgMessage = wxT("");
	dlgStyle = wxOK;
}


Erreur::~Erreur()
{
}

void Erreur::newMessage(P11E_TYPE _type, 
			std::string _title, 
			std::string _explanation)
{
	dlgMessage = wxString::FromAscii(_title.c_str()) 
		+ wxString::FromAscii("\n\n")
		+ wxString::FromAscii(_explanation.c_str());
	
	dlgStyle = wxOK;
	if(_type == P11Error::P11E_ERROR) dlgStyle = dlgStyle | wxICON_ERROR;
	else if(_type == P11Error::P11E_INFO) dlgStyle = dlgStyle | wxICON_INFORMATION;
	
	wxMessageDialog * dlg = new wxMessageDialog(parentwindow, 
			dlgMessage,
			dlgCaption,
			dlgStyle,
			wxDefaultPosition);
	dlg->ShowModal();
}
