/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef __ADD_CRL_DLG_HH_
#define __ADD_CRL_DLG_HH_

#include <wx/wx.h>
#include <wx/string.h>

#include "CryptonitDlg.hh"
#include "../Certificate.hh"
#include "../User.hh"

using namespace Cryptonit;

#define ERROR_CRL_WRONG_ISSUER  -1
#define ERROR_CRL_SAVE_FILE     -2
#define ERROR_CRL_CONFIG_UPDATE -3
#define ERROR_CRL_NOT_UNIQUE    -4
#define ERROR_CRL_WRITE_FILE    -5
#define ERROR_CRL_LOAD          -6
#define ERROR_CRL_NO_CA_ISSUER  -7

class AddCrlDlg : public CryptonitDlg{

public:
    AddCrlDlg(wxWindow *parent, wxWindowID id,
	      const wxString& title=_T(""),
	      const wxString& defaultLDAPDN=_T(""),
	      const wxString& defaultURI=_T("http://"));
    
    bool isFile();
    bool isURI();
    bool isLDAP();
    
    

    static wxString fetchCrl( wxString uri );
    static bool deleteCrl( std::string *name , Certificate c , User *user );
    static int updateCrl( wxString uri , Certificate C , User *user);
    static int saveCrl( wxString uri , Crl *crl , Certificate C , User *user );

    wxString getFile();
    wxString getURI();
    wxArrayString* getLDAP();
    
    


private:

    void onFile(wxCommandEvent &WXUNUSED(event));
    void onUri(wxCommandEvent &WXUNUSED(event));
    void onLDAP(wxCommandEvent &WXUNUSED(event));
    void onFileBtn(wxCommandEvent &WXUNUSED(event));

    wxRadioButton *fileRadio;
    wxRadioButton *uriRadio;
    wxRadioButton *ldapRadio;

    wxTextCtrl *file;
    wxTextCtrl *uri;
    
    wxBitmapButton *fileBtn;
    
    wxTextCtrl* serverName;
    wxTextCtrl* serverPort;
    wxTextCtrl* baseDN;
    wxTextCtrl* authorityFilter;

    DECLARE_EVENT_TABLE()
};

enum
    {
	ACD_FILE_BTN_ID = 13000,
	ACD_FILE_RADIO_ID,
	ACD_URI_RADIO_ID,
	ACD_LDAP_RADIO_ID
    };

#endif
