/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#ifndef _P11_SLOT_HH_
#define _P11_SLOT_HH_

#include "pkcs11/pkcs11_util.h"

#include "Key.hh"
#include "P11Error.hh"
#include "P11Session.hh"

namespace Cryptonit {
	/** A PKCS#11 slot, which corresponds to a physical reader or other device interface.
	 * A token is present in the slot when a cryptographic device is present in the reader.
	 */

enum GetKeyReturn
{
	gkrSUCCESS,
	gkrBAD_PASSWORD,
	gkrCANCELED,
	gkrINVALID
};

class P11Slot
{
public:
	P11Slot(CK_FUNCTION_LIST_PTR funcs, CK_SLOT_ID s, P11Error * em, PasswordManager *m);
	~P11Slot();
	
	/* Get the list of Certificates
	 * @return a vector of Certificate
	 */
	std::vector<Certificate> listCertificates();
	
	/** Get the Key corresponding to the Certificate
	 * You should save it as a pkcs8 object.
	 */
	GetKeyReturn getKey(Certificate c, Key **k);

	//! @return true if the slot has a token in it, false otherwise
	bool hasToken();

	CK_SLOT_ID getSlotId() {return slotId;}
	CK_SLOT_INFO slotInfo();
	CK_TOKEN_INFO tokenInfo();
	
	// These functions are only provided for displaying information
	CK_STATE getSessionState() { return session->getState(); }
	CK_SESSION_INFO getSessionInfo() { return session->getInfo(); }
	CK_SESSION_HANDLE getSessionHandle() { return session->handle(); }
	//void login(){session->login();}
	
private:
	P11Error * err;
	
	/**
	 * We need a class able to give us the user-given passphrase.
	 * This class has to be external to the library, because User Interface
	 * is out of our scope. pm must point to a working subclass of PasswordManager.
	 */
	PasswordManager *pm;

	CK_FUNCTION_LIST_PTR funcs; //!< PKCS#11 function pointers

	P11Session * session; //!< the session object manages session-related operations

	CK_SLOT_ID slotId; //!< PKCS#11 ID of this slot
      
	/**
	 * The meaning of pair has changed ! now the "second" field holds the 
	 * handle to the certificate itself, and not the associated private key
	 */
	std::vector< std::pair<Certificate, CK_OBJECT_HANDLE> > cache;
}; // class P11Slot
	
} //namespace Cryptonit

#endif
