/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _P11_ERROR_HH_
#define _P11_ERROR_HH_


#ifndef WIN32
#include "pkcs11/unix.h"
#else
#include "pkcs11/win32.h"
#endif
#include "pkcs11/pkcs11.h"


#include <string>

namespace Cryptonit
{

/** Info/Error message management class.
 * This class is useful for reporting error or information messages coming
 * from the Cryptoki API. The hardware part of this API means that many
 * factors can be responsible for various inexpected operating states.
 * Here is an abstract class which application developers can (must) subclass
 * to get the messages and process them appropriately.
 * It's up to developers to decide what they do with the messages : they
 * can pop-up a message dialog, with an icon depending on the type of
 * the message, and/or they can output it to stdout/stderr
 */
class P11Error
{
public:

	enum P11E_TYPE {P11E_INFO, P11E_ERROR};

	/** Check the return value given as argument rv against common types of error
	 * and output an appropriate message with newMessage().
	 */
	void checkRV(CK_RV rv = CKR_OK);
	
	/** This function is to be overridden. Its role is to output the given message, 
	 * using a dialog window or the command-line. It could use a std::queue to
	 * temporarily store messages.
	 */
	virtual void newMessage(P11E_TYPE _type, 
			std::string _title, 
			std::string _explanation = "") = 0;
			

private:

};

/** Error or information message structure.
 * The fields have the following meaning :
 * - type is either P11E_INFO or P11E_ERROR
 * - message is the error message
 * - explanation is a more complete, but optional, explanation of the error.
 */
typedef struct
{
	P11Error::P11E_TYPE type;
	std::string message;
	std::string explanation;
}P11E_Message;

} // namespace Cryptonit

#endif // _P11_ERROR_HH_
