/* 
 * edit_pud.c
 *
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "crafted.h"
#include "craftedintl.h"

#include "crafteddialog.h"

static GtkWidget *edit_pud_dialog = NULL;

/*************************************************************************
*  edit_pud_ok
**************************************************************************/
static void edit_pud_ok(void)
{
  gint width, height;
  gint terrain;
  gint i;
  GtkWidget *entry;
  GtkWidget *spin;

/*  terrain = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(new_pud_dialog), "terrain"));*/

  Pud.is_loaded   = TRUE;
  Pud.modified    = TRUE;
  /* get description */
  entry = gtk_object_get_data(GTK_OBJECT(edit_pud_dialog), "description");
  if (Pud.description) g_free(Pud.description);
  Pud.description = g_strdup(gtk_entry_get_text(GTK_ENTRY(entry)));
/*  Pud.terrain     = terrain; */
  for (i=0 ; i<15 ; i++)
  {
    gchar *owner, *side, *gold, *wood, *oil, *ai;

    owner = g_strdup_printf("owner%d", i);
    Pud.player[i].owner = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(edit_pud_dialog), owner))+2;
    g_free(owner);
    side = g_strdup_printf("side%d", i);
    Pud.player[i].side = GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(edit_pud_dialog), side));
    g_free(side);
    gold = g_strdup_printf("gold%d", i);
    spin = gtk_object_get_data(GTK_OBJECT(edit_pud_dialog), gold);
    Pud.player[i].gold = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    g_free(gold);
    wood = g_strdup_printf("wood%d", i);
    spin = gtk_object_get_data(GTK_OBJECT(edit_pud_dialog), wood);
    Pud.player[i].wood = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    g_free(wood);
    oil = g_strdup_printf("oil%d", i);
    spin = gtk_object_get_data(GTK_OBJECT(edit_pud_dialog), oil);
    Pud.player[i].oil = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    g_free(oil);
    ai = g_strdup_printf("ai%d", i);
    spin = gtk_object_get_data(GTK_OBJECT(edit_pud_dialog), ai);
    Pud.player[i].ai = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin));
    g_free(ai);
  }
  Pud.player[15].owner = 2; /* neutral */
  Pud.player[15].side = 2; /* neutral */
  Pud.player[15].gold = 1000;
  Pud.player[15].wood = 1000;
  Pud.player[15].oil = 1000;

  after_load();
  gtk_widget_destroy(edit_pud_dialog);
}

/*static void edit_pud_terrain_changed(GtkWidget *dum, gpointer data)
{
  gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), "terrain", data);
}*/

/*************************************************************************
*  edit_pud_owner_changed
**************************************************************************/
static void edit_pud_owner_changed(GtkWidget *dum, gpointer data)
{
  int    rank, state, i;
  gchar *owner;

  i = GPOINTER_TO_INT(data);
  rank  = i / 16;
  state = i % 16;
  owner = g_strdup_printf("owner%d", rank);
  gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), owner,
                                 GINT_TO_POINTER(state));
  g_free(owner);
}

/*************************************************************************
*  edit_pud_side_changed
**************************************************************************/
static void edit_pud_side_changed(GtkWidget *dum, gpointer data)
{
  int    rank, state, i;
  gchar *side;

  i = GPOINTER_TO_INT(data);
  rank  = i / 16;
  state = i % 16;
  side = g_strdup_printf("side%d", rank);
  gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), side,
                      GINT_TO_POINTER(state));
  g_free(side);
}

/*************************************************************************
*  toggle_race
**************************************************************************/
static void toggle_race(GtkToggleButton *check, GtkWidget *widget)
{
  gtk_widget_set_sensitive(widget, gtk_toggle_button_get_active(check));
}

/*************************************************************************
*  edit_pud_callback
**************************************************************************/
void edit_pud_callback(void)
{
  GtkWidget *label, *button, *hbox, *vbox;
  GtkWidget *menu_item, *option_menu, *menu;
  GtkWidget *entry, *table, *frame, *spin;
  GtkWidget *hbbox, *notebook;
  GtkAdjustment *adj;
  gint i;

  if (edit_pud_dialog)
  {
    if (!GTK_WIDGET_VISIBLE(edit_pud_dialog))
    {
      gtk_widget_show(edit_pud_dialog);
    } else
    {
      gdk_window_raise(edit_pud_dialog->window);
    }
    return;
  }

  edit_pud_dialog = crafted_dialog_new(_("Edit players"),
                                       "crafted",
                                       GTK_WIN_POS_MOUSE,
                                       TRUE, TRUE, FALSE,
                                       _("OK"), edit_pud_ok,
                                       NULL, 1, NULL, TRUE, FALSE,
                                       _(" Cancel "), gtk_widget_destroy,
                                       NULL, 1, NULL, FALSE, TRUE, NULL);
  gtk_signal_connect(GTK_OBJECT(edit_pud_dialog), "destroy",
                     (GtkSignalFunc)gtk_widget_destroyed,
                     &edit_pud_dialog);

  /* Description */
  hbox = gtk_hbox_new(FALSE, 4);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(edit_pud_dialog)->vbox), hbox, FALSE, FALSE, 4);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), 4);
  
  label = gtk_label_new(_("Description: "));
  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 4);
  
  entry = gtk_entry_new();
  gtk_box_pack_start_defaults(GTK_BOX(hbox), entry);
  gtk_entry_set_text(GTK_ENTRY(entry), Pud.description);
  gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), "description", entry);

  /* Races toggles */
  table = gtk_table_new(2, 4, TRUE);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(edit_pud_dialog)->vbox), table, FALSE, FALSE, 4);

  /* Races settings */
  notebook = gtk_notebook_new();
  gtk_notebook_set_scrollable(GTK_NOTEBOOK(notebook), TRUE);
  gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(edit_pud_dialog)->vbox), notebook);

  for (i=0 ; i<15 ; i++)
  {
    gchar *frame_title, *owner, *side, *gold, *wood, *oil, *ai;
    GtkWidget *frame_vbox, *resource_table, *label;
    GtkAdjustment *adj;
    GtkWidget *spin, *check, *tab_label;

    frame_title = g_strdup_printf(_("Player #%d"), i+1);
    frame = gtk_frame_new(frame_title);
    tab_label = gtk_label_new(frame_title);
    gtk_notebook_append_page(GTK_NOTEBOOK(notebook), frame, tab_label);
    check = gtk_check_button_new_with_label(frame_title);
    gtk_signal_connect(GTK_OBJECT(check), "toggled",
                       (GtkSignalFunc)toggle_race, frame);
    gtk_signal_connect(GTK_OBJECT(check), "toggled",
                       (GtkSignalFunc)toggle_race, tab_label);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), TRUE);
    if (Pud.player[i].owner == 3)
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check), FALSE);

    gtk_table_attach_defaults(GTK_TABLE(table), check, i%4, i%4+1, i/4, i/4+1);
    g_free(frame_title);

    hbox = gtk_hbox_new(FALSE, 4);
    gtk_container_add(GTK_CONTAINER(frame), hbox);
 
    frame_vbox = gtk_vbox_new(FALSE, 4);
    gtk_box_pack_start_defaults(GTK_BOX(hbox), frame_vbox);

    /* Owner */
    menu = gtk_menu_new();
    menu_item = gtk_menu_item_new_with_label(_("Neutral"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_owner_changed,
                       GINT_TO_POINTER(i*16+0));
    menu_item = gtk_menu_item_new_with_label(_("Nobody"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_owner_changed,
                       GINT_TO_POINTER(i*16+1));
    menu_item = gtk_menu_item_new_with_label(_("Computer"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_owner_changed,
                       GINT_TO_POINTER(i*16+2));
    menu_item = gtk_menu_item_new_with_label(_("Person"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_owner_changed,
                       GINT_TO_POINTER(i*16+3));
    menu_item = gtk_menu_item_new_with_label(_("Rescue (passive)"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_owner_changed,
                       GINT_TO_POINTER(i*16+4));
    menu_item = gtk_menu_item_new_with_label(_("Rescue (active)"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_owner_changed,
                       GINT_TO_POINTER(i*16+5));
    option_menu = gtk_option_menu_new();
    gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), menu);
    gtk_box_pack_start_defaults(GTK_BOX(frame_vbox), option_menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(option_menu), Pud.player[i].owner-2);
    owner = g_strdup_printf("owner%d", i);
    gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), owner, GINT_TO_POINTER(1));
    g_free(owner);

    /* Side */
    menu = gtk_menu_new();
    menu_item = gtk_menu_item_new_with_label(_("Human"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_side_changed,
                       GINT_TO_POINTER(i*16+0));
    menu_item = gtk_menu_item_new_with_label(_("Orc"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_side_changed,
                       GINT_TO_POINTER(i*16+1));
    menu_item = gtk_menu_item_new_with_label(_("Neutral"));
    gtk_menu_append(GTK_MENU(menu), menu_item);
    gtk_widget_show(menu_item);
    gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
                       (GtkSignalFunc)edit_pud_side_changed,
                       GINT_TO_POINTER(i*16+2));
    option_menu = gtk_option_menu_new();
    gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), menu);
    gtk_box_pack_start_defaults(GTK_BOX(frame_vbox), option_menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(option_menu), Pud.player[i].side);
    side = g_strdup_printf("side%d", i);
    gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), side, GINT_TO_POINTER(0));
    g_free(side);

    /* Gold */
    resource_table = gtk_table_new(2, 3, FALSE);
    gtk_box_pack_start_defaults(GTK_BOX(frame_vbox), resource_table);
    label = gtk_label_new(_("Gold:"));
    gtk_table_attach_defaults(GTK_TABLE(resource_table), label, 0,1, 0,1);
    adj = (GtkAdjustment *)gtk_adjustment_new(1000.0, 0.0, 65535.0, 1.0, 10.0, 10.0);
    spin = gtk_spin_button_new(adj, 1.0, 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), Pud.player[i].gold);
    gtk_table_attach_defaults(GTK_TABLE(resource_table), spin, 1,2, 0,1);
    gold = g_strdup_printf("gold%d", i);
    gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), gold, spin);
    g_free(gold);
    
    /* Wood */
    label = gtk_label_new(_("Wood:"));
    gtk_table_attach_defaults(GTK_TABLE(resource_table), label, 0,1, 1,2);
    adj = (GtkAdjustment *)gtk_adjustment_new(1000.0, 0.0, 65535.0, 1.0, 10.0, 10.0);
    spin = gtk_spin_button_new(adj, 1.0, 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), Pud.player[i].wood);
    gtk_table_attach_defaults(GTK_TABLE(resource_table), spin, 1,2, 1,2);
    wood = g_strdup_printf("wood%d", i);
    gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), wood, spin);
    g_free(wood);
    
    /* Oil */
    label = gtk_label_new(_("Oil:"));
    gtk_table_attach_defaults(GTK_TABLE(resource_table), label, 0,1, 2,3);
    adj = (GtkAdjustment *)gtk_adjustment_new(1000.0, 0.0, 65535.0, 1.0, 10.0, 10.0);
    spin = gtk_spin_button_new(adj, 1.0, 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), Pud.player[i].oil);
    gtk_table_attach_defaults(GTK_TABLE(resource_table), spin, 1,2, 2,3);
    oil = g_strdup_printf("oil%d", i);
    gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), oil, spin);
    g_free(oil);

    /* ai */
    gtk_box_pack_start(GTK_BOX(hbox), gtk_vseparator_new(), FALSE, FALSE, 4);
    vbox = gtk_vbox_new(FALSE, 4);
    gtk_box_pack_start_defaults(GTK_BOX(hbox), vbox);
    hbox = gtk_hbox_new(FALSE, 4);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 4);
    label = gtk_label_new(_("A.I. "));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 4);
    adj = (GtkAdjustment *)gtk_adjustment_new(0,0,255,1,1,1);
    spin = gtk_spin_button_new(adj, 1, 0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), Pud.player[i].ai);
    gtk_box_pack_start_defaults(GTK_BOX(hbox), spin);
    ai = g_strdup_printf("ai%d", i);
    gtk_object_set_data(GTK_OBJECT(edit_pud_dialog), ai, spin);
    g_free(ai);
  }

  gtk_window_set_modal(GTK_WINDOW(edit_pud_dialog), TRUE);
  
  gtk_widget_show_all(edit_pud_dialog);
}

