/*
 * crafted_png.h
 * crafted - a pud editor for the freecraft project.
 * 
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __CRAFTED_PNG_H__
#define __CRAFTED_PNG_H__

typedef struct Graphic
{
  guint width, height;
  GdkPixmap *pixmap;
  GdkPixmap *mask;
} Graphic;

Graphic *LoadGraphicPNG(const gchar* name);

Graphic **load_graphic_PNG_with_size(const gchar *name,
                                     guint width, guint height);

#endif /* __CRAFTED_PNG_H__ */
