#ifndef __wxterminal__
#define __wxterminal__

/**
@file
Subclass of wxTerminalBase, which is generated by wxFormBuilder.
*/

#include "wxterminalbase.h"
#include <set>

class IProcess;

class wxTerminalHistory
{
	wxArrayString m_history;
	size_t        m_historyCursor;

public:
	wxTerminalHistory();
	~wxTerminalHistory();

	void     AddCommand( const wxString &command );
	wxString ArrowUp   ();
	wxString ArrowDown ();
};

/** Implementing wxTerminalBase */
class wxTerminal : public wxTerminalBase
{
protected:
	wxTerminalHistory   m_history;
	int                 m_commandStart;
	IProcess*           m_process;
	int                 m_inferiorEnd;
	wxString            m_workingDir;
	wxTextAttr          m_defaultStyle;
	wxTextAttr          m_promptStyle;
	bool                m_exitWhenProcessDies;
	bool                m_exitOnKey;
	wxString            m_promptFormat;

protected:
	wxString DoGetLastLine();
	void     DoProcessCommand(const wxString &command);
	void     DoInsertLine(const wxString& value);
	void     DoWritePrompt();
	bool     CheckForCD( const wxString &command, wxString &path );
	void     DoFixSelection();
	void     DoCtrlC();

protected:
	// Handlers for wxTerminalBase events.
	DECLARE_EVENT_TABLE()
	virtual void OnText             ( wxCommandEvent& event );
	virtual void OnEnter            ( wxCommandEvent& event );
	virtual void OnURL              ( wxTextUrlEvent& event );
	virtual void OnKey              ( wxKeyEvent    & event );
	virtual void OnReadProcessOutput(wxCommandEvent & event );
	virtual void OnProcessEnd       (wxCommandEvent & event );

public:
	/** Constructor */
	wxTerminal( wxWindow* parent );

	// API
	void     Execute             (const wxString &command, bool exitWhenDone = false);
	void     KillInferior        ();
	void     SetReadOnly         (bool readOnly);
	void     SetWorkingDirectory (const wxString &workingDirectory);
	bool     IsRunning           ();
	void     Clear               ();
	void     SetPromptFormat     (const wxString &promptFormat);
};

#endif // __wxterminal__
