/*============================================================================
 * Main Code_Saturne documentation page
 *============================================================================*/

/*
  This file is part of Code_Saturne, a general-purpose CFD tool.

  Copyright (C) 1998-2018 EDF S.A.

  This program is free software; you can redistribute it and/or modify it under
  the terms of the GNU General Public License as published by the Free Software
  Foundation; either version 2 of the License, or (at your option) any later
  version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
  details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
  Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

/*-----------------------------------------------------------------------------*/

/*!
  \mainpage Code_Saturne documentation

  \section mainpage_intro Introduction

  Code_Saturne is EDF's general purpose Computational Fluid Dynamics (CFD)
  software.

  The basic capabilities of Code_Saturne enable the handling of either
  incompressible or expandable flows with or without heat transfer and
  turbulence. Dedicated modules are available for specific physics such as
  radiative heat transfer, combustion (gas, coal, heavy fuel oil, ...),
  magneto-hydrodynamics, compressible flows, two-phase flows
  (Euler-Lagrange approach with two-way coupling), or atmospheric flows.

  \section mainpage_install Installation

  Code_Saturne may be configured and installed using the
  \c configure shell script and \c make. Please read the \c INSTALL
  file in the toplevel source directory if you are not familiar
  with configuration scripts generated through GNU autoconf and automake.

  \section mainpage_sublibs Sub-libraries

  See \ref mainpage_ple "PLE" (Parallel Location and Exchange).

  \section mainpage_user_sources User sources, functions, and subroutines

  Many user examples are available in the \ref cs_user_examples "user examples tab":
    - \ref cs_user_boundary_conditions_examples "User boundary conditions definitions",
    - \ref cs_user_extra_operations_examples "User extra operations",
    - \ref cs_user_initialization "Physical fields user initialization",
    - and so on ...

  \section additional_doc Additional documentation

  In addition to the Doxygen documentation, Code_Saturne is provided with six
  pdf documents:
    - a <a href="../../user.pdf"><b>user guide</b></a>,
    - a <a href="../../theory.pdf"><b>theory guide</b></a>,
    - a <a href="../../developer.pdf"><b>developer guide</b></a>,
    - a <a href="../../studymanager.pdf"><b>guide of studymanager</b></a>,
    - an <a href="../../install.pdf"><b>installation guide</b></a>,
    - a <a href="../../refcard.pdf"><b>refcard</b></a>.

*/
