#!/bin/sh

if [[ ! -f /usr/share/common-lisp/source/defsystem/defsystem.lisp ]] ; then
  cat <<EOF
$0: cannot find the defsystem source.
This should not happen. Please report this
as a bug.
EOF
  exit 0
fi

case ${0##*/} in
 cmucl-normal.sh)
 	echo CMUCL normal script.
	IMAGE=/usr/lib/cmucl/lisp-normal.core
	DIR=cmucl-normal
	;;
 cmucl-small.sh)
 	echo CMUCL small script.
	IMAGE=/usr/lib/cmucl/lisp-small.core
	DIR=cmucl-small
	;;
 cmucl-safe.sh)
 	echo CMUCL safe script.
	IMAGE=/usr/lib/cmucl/lisp-safe.core
	DIR=cmucl-safe
	;;
 *)
 	echo unknown CMUCL script call: $0
	exit 1
	;;
esac

case $1 in
    rebuild)
	    echo $0 rebuilding...
	    shift
	    while [ ! -z "$1" ] ; do
		echo rebuilding $1
		lisp -core $IMAGE -eval "
(let ((*gc-verbose* nil)
      (*compile-print* nil)
      (*compile-progress* nil)
      (*compile-verbose*  nil)
      (*require-verbose* nil)
      (*load-verbose* nil))
  (load \"/var/lib/cmucl/site-init.lisp\"))
(let ((*gc-verbose* nil)
      (*compile-print* nil)
      (*compile-progress* nil)
      (*compile-verbose*  nil)
      (*require-verbose* nil)
      (*load-verbose* nil)
      (mk::*load-source-if-no-binary* nil)
      (mk::*bother-user-if-no-binary* nil)
      (mk::*compile-during-load* t))

    (locally (declare (optimize (inhibit-warnings 3)))
	(mk:oos :$1 :compile :verbose nil)))
(unix:unix-exit 0)" -nositeinit -noinit -batch -quiet 
		shift
 	    done 
	    ;;
     remove)
	    echo $0 removing packages...
	    shift
	    while [ ! -z "$1" ] ; do
		rm -rf "/usr/lib/common-lisp/$DIR/$1"
		shift
 	    done
	    rmdir /usr/lib/common-lisp/$DIR 2> /dev/null 
	    ;;
    install-defsystem)
    	    echo installing the defsystem...
	    ( cd /usr/lib/cmucl
	      # does an old image allready exists?
	      if [ ! -f ${IMAGE%.core}-old.core ] ; then
	        mv $IMAGE ${IMAGE%.core}-old.core 
              fi
	     lisp  \
	       -core ${IMAGE%.core}-old.core -load /usr/lib/cmucl/install-defsystem.lisp \
	       -nositeinit -noinit -batch -quiet  && \
               mv new-lisp.core $IMAGE || (echo FAILED ; mv ${IMAGE%.core}-old.core $IMAGE ) )
    	    ;;
    remove-defsystem)
	    if [ -f ${IMAGE%.core}-old.core ] ; then
	      mv ${IMAGE%.core}-old.core $IMAGE
	    fi
    	    ;;
    make-user-image)
    	    if [[ ! -f $1 ]] ; then 
	      echo Cannot find file $1 to load and dump!
	      exit 321
	    fi
	    lisp -core $IMAGE -eval "
(load \"$1\")
    ;;
    ;; Enable the garbage collector.  But first fake it into thinking that
    ;; we don't need to garbage collect.  The save-lisp is going to call
    ;; purify so any garbage will be collected then.
#-gengc (setf lisp::*need-to-collect-garbage* nil)
(gc-on)
    ;;
    ;; Save the lisp.
(setf ext:*batch-mode* nil)
(save-lisp #p\"home:lisp.core\")" -nositeinit -noinit -batch -quiet && echo New image created
	    ;;
    *)
	    echo $0 unkown command $1
	    echo known commands: install-defsystem, remove-defsystem,rebuild and remove
	    exit 1
	    ;;
esac

exit 0
