cmake_minimum_required(VERSION 3.10)
project(DeploymentTarget C)

# using Xcode 7.1 SDK versions for deployment targets

if(SDK MATCHES iphone)
  set(CMAKE_OSX_SYSROOT ${SDK})
  set(CMAKE_OSX_ARCHITECTURES "armv7;x86_64")
  set(CMAKE_OSX_DEPLOYMENT_TARGET "9.1")
  set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGNING_REQUIRED "NO")
  set(CMAKE_XCODE_ATTRIBUTE_ENABLE_BITCODE "NO")
elseif(SDK MATCHES watch)
  set(CMAKE_OSX_SYSROOT ${SDK})
  set(CMAKE_OSX_ARCHITECTURES "armv7k;i386")
  set(CMAKE_OSX_DEPLOYMENT_TARGET "2.0")
  set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGNING_REQUIRED "NO")
  set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGN_IDENTITY "")
  set(CMAKE_XCODE_ATTRIBUTE_ENABLE_BITCODE "YES")
elseif(SDK MATCHES appletv)
  set(CMAKE_OSX_SYSROOT ${SDK})
  set(CMAKE_OSX_DEPLOYMENT_TARGET "9.0")
  set(CMAKE_OSX_ARCHITECTURES "arm64;x86_64")
  set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGNING_REQUIRED "NO")
  set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGN_IDENTITY "")
  set(CMAKE_XCODE_ATTRIBUTE_ENABLE_BITCODE "YES")
else()
  set(CMAKE_OSX_SYSROOT ${SDK})
  set(CMAKE_OSX_DEPLOYMENT_TARGET "10.11")
endif()

add_library(myFramework STATIC DeploymentTarget.c)
set_target_properties(myFramework PROPERTIES FRAMEWORK TRUE)
