# ########################################################################
# Copyright 2015 Vratis, Ltd.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ########################################################################

MESSAGE(STATUS "running cl2cpp_raw")

file(GLOB cl_list "${CL_DIR}/*.cl" )

file(WRITE ${OUTPUT} "// This file is auto-generated. Do not edit!

#include \"internal/source-provider.hpp\"

namespace internal
{
")

#I still want to have this file autogenerated. It is very easy to
#forget adding the new entry when new kernel is added.

#this will generate #include <absolute_path>/<kernel_name>.cl
#should not be an issue since content is generated during compilation time

#foreach(cl ${cl_list})
#  get_filename_component(cl_filename "${cl}" NAME_WE)
#  message("${cl_filename}")
#  file(APPEND ${OUTPUT} "const char* ${cl_filename}=\n #include \"${cl}\"\n;\n")
#endforeach()

#this will generate relative path. it seems cleaner
foreach(cl ${cl_list})
  get_filename_component(cl_filename "${cl}" NAME_WE)
  message("${cl_filename}")
  file(APPEND ${OUTPUT} "const char* ${cl_filename}=\n #include \"kernels/${cl_filename}.cl\"\n;\n")
endforeach()


file(APPEND ${OUTPUT} "}\n")


file(APPEND ${OUTPUT} "

std::map<std::string, const char*> SourceProvider::map(SourceProvider::MapInit());

std::map<std::string, const char*> SourceProvider::MapInit()
{
	std::map<std::string, const char*> internal_map;
")

foreach(cl ${cl_list})
  get_filename_component(cl_filename "${cl}" NAME_WE)

  file(APPEND ${OUTPUT} "
	internal_map[\"${cl_filename}\"] = internal::${cl_filename};\n")
endforeach()




file(APPEND ${OUTPUT} "
	return internal_map;
}
")
