/* tolua
** Support code for Lua bindings.
** Written by Waldemar Celes
** TeCGraf/PUC-Rio
** Jul 1998
** $Id: tolua_lb.c,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $
*/

/* This code is free software; you can redistribute it and/or modify it. 
** The software provided hereunder is on an "as is" basis, and 
** the author has no obligation to provide maintenance, support, updates,
** enhancements, or modifications. 
*/

#include "tolua.h"
#include "tolua_st.h"
#include "tolua_tm.h"
#include "tolua_tt.h"

/* store reference for 'foreach' function */
static int foreach_ref;

int tolua_open (void)
{
 int tolua_tolua_open (void);
 int status = 0;
 lua_Object lo;
 lua_open();
 lua_beginblock();
 lo = lua_getglobal(".tolua_state");
 if (!lua_istable(lo))
 {
  toluaI_st_init();
  toluaI_tt_init();
  toluaI_tm_init();
  lua_pushobject(lua_getglobal("foreach"));
  foreach_ref = lua_ref(0);
  toluaI_st_store(&foreach_ref);
  tolua_tolua_open();	/* opens tolua own binding */
  status = 1;
 }
 lua_endblock();
 return 0;
}

void tolua_restorestate (void)
{
 toluaI_st_restore();
}

void tolua_using (lua_Object module)
{
 toluaI_tm_using(module);
}

void tolua_class (lua_Object derived, lua_Object base)
{
 int tag = lua_newtag();    /* new tag of instances of that class */
 toluaI_tm_setclass(derived);
 toluaI_tm_linstance(tag,derived);
 lua_pushobject(derived);
 lua_pushstring(".base");
 lua_pushobject(base);
 lua_rawsettable();
 lua_pushobject(derived);
 lua_pushstring(".itag");
 lua_pushnumber(tag);
 lua_rawsettable();
}

void tolua_instance (lua_Object instance, lua_Object classobj)
{
 int tag;
 lua_pushobject(classobj);
 lua_pushstring(".itag");
 tag = (int) lua_getnumber(lua_gettable());
 if (tag==0)
  tolua_error("unregistered 'classobj' in function 'tolua_instance'.");
 lua_pushobject(instance);
 lua_settag(tag);
}

static void filter (void)
{
 lua_Object f = lua_getparam(1);
 lua_Object n = lua_getparam(2);
 lua_Object v = lua_getparam(3);
 /* do not pass string fields starting with a dot */
 if (!lua_isstring(n) || *lua_getstring(n)!='.')
 {
  lua_pushobject(n);
  lua_pushobject(v);
  lua_callfunction(f);
 }
}

void tolua_foreach (lua_Object lo, lua_Object f)
{
 if (toluaI_tt_isusertype(lo))
 {
  lo = toluaI_tm_getmate(lo);
  if (lua_isnil(lo))
   return;    /* no field in mate table */
 }
 lua_pushobject(lo);
 lua_pushobject(f);
 lua_pushcclosure(filter,1);
 lua_callfunction(lua_getref(foreach_ref));
}

char* tolua_type (lua_Object lo)
{
 return toluaI_tt_getobjtype(lo);
}

int tolua_tag (char* type)
{
 return toluaI_tt_gettag(type);
}

lua_Object tolua_base (lua_Object lo)
{
 if (toluaI_tt_isusertype(lo))
  return lo = toluaI_tm_getclass(lo);
 else if (lua_istable(lo))
 {
  lua_pushobject(lo); lua_pushstring(".base");
  return lua_rawgettable();
 }
 else
  return TOLUA_NIL;
}

lua_Object tolua_cast (lua_Object lo, char* type)
{
 if (lua_isuserdata(lo))
 {
  tolua_pushusertype(lua_getuserdata(lo),toluaI_tt_gettag(type));
  return lua_pop();
 }
 else
  return TOLUA_NIL;
}

void tolua_takeownership (lua_Object lo)
{
 if (toluaI_tt_isusertype(lo))
 {
  tolua_doclone(lua_getuserdata(lo),lua_tag(lo));  
 }
 else
  tolua_error("cannot take ownership of specified obejct.");
}

