/*
	$Id: thread_pthread.cpp,v 1.1.1.1 2000/04/09 12:18:02 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <pthread.h>
#include "API/Core/System/cl_assert.h"
#include "thread_pthread.h"

CL_Thread *CL_Thread::create(CL_Runnable *runnable)
{
	return new CL_Thread_Posix(runnable);
}

CL_Thread_Posix::CL_Thread_Posix(CL_Runnable *runnable)
{
	this->runnable = runnable;
	running = false;
}

CL_Thread_Posix::~CL_Thread_Posix()
{
	terminate();
}

void CL_Thread_Posix::start()
{
	if (running) return;

	cl_assert(
		pthread_create(
			&thread,
			NULL,
			run_init,
			this)==0);

	running = true;
}

void *CL_Thread_Posix::run_init(void *_self)
{
	CL_Thread_Posix *self = (CL_Thread_Posix *) _self;

	// kill thread immidiately - no cancelation point...
	pthread_setcanceltype(PTHREAD_CANCEL_ASYNCHRONOUS, NULL);

	self->runnable->run();
	return NULL;
}

void CL_Thread_Posix::terminate()
{
	if (running) pthread_cancel(thread);
	running = false;
}

void CL_Thread_Posix::wait()
{
	if (running) pthread_join(thread, NULL);
	running = false;
}
