/*
	$Id: implementation_fbdev.cpp,v 1.2 2000/04/25 21:40:16 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------

	File purpose:
		Initialization functions for FBDev implementation.

*/

#include "Core/precomp.h"

#ifdef USE_FBDEV

#include "implementation_fbdev.h"
#include "API/Core/Display/display.h"
#include "Core/Display/FBDev/display_fbdev.h"
#include "API/Core/Input/input.h"
//#include "Core/Input/FBDev/mouse_fbdev.h"
#include "Core/Input/TTY/keyboard_tty.h"
#include "Core/Input/X11/joystick_linux.h"
#include "implementation.h"

bool CL_Implementation_FBDev::initialized = false;
int CL_Implementation_FBDev::display_counter=0;

static CL_Implementation_FBDev impl_fbdev;

extern "C"
{
	DL_PREFIX char* clan_module_identify()
	{
		return "Linux FBDEV target";
	}

	DL_PREFIX char* clan_module_abbreviation()
	{
		return "fbdev";
	}

	DL_PREFIX void clan_module_init()
	{
		impl_fbdev.add_display();
	}
}

char *fbdev_identify()
{
	return clan_module_identify();
}

char *fbdev_abbreviation()
{
	return clan_module_abbreviation();
}

void fbdev_init()
{
	clan_module_init();
}

CL_Implementation_FBDev::~CL_Implementation_FBDev()
{
	clean_up();
}

bool CL_Implementation_FBDev::init()
{
	if (initialized) return true;

	return true;
}

void CL_Implementation_FBDev::clean_up()
{
	if (display_counter == 0) return; // nothing to clean up...

	display_counter--;
	if (display_counter>0) return;
}

void CL_Implementation_FBDev::add_display()
{
	if (init() == false)
	{
		std::cout << "ClanLib: Failed to open display. No FBDev display available." << std::endl;
	}

	CL_FBDev_DisplayCard *card = new CL_FBDev_DisplayCard(display_counter);

	CL_Display::cards.push_back(card);

	CL_Input::keyboards.push_back(new CL_TTYKeyboard());
//	CL_Input::pointers.push_back(new CL_Mouse_FBDev());

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,1,0)

	for (int i=0; i<8; i++)
	{
		CL_LinuxJoystick *joy = new CL_LinuxJoystick();
		if (joy->init(i))
			CL_Input::joysticks.push_back(joy);
		else
			delete joy;
	}

#endif

	display_counter++;
}

#endif
