
#include "Core/precomp.h"
#include "API/Core/System/system.h"
#include "API/Core/System/cl_assert.h"

static bool do_3dnow_test();

bool CL_System::detect_3dnow()
{
	static bool has_3dnow = false;
	static bool first_time = true;
	
	if (first_time)
	{
		first_time = false;
		has_3dnow = do_3dnow_test();
	}
	
	return has_3dnow;
}

static bool do_3dnow_test()
{
#ifdef WIN32
	unsigned long RegEDX = 0;
	unsigned long RegEAX = 0;

	try 
	{
		_asm
		{
			mov		eax, 0x80000000		// set up CPUID to return processor extended functions
			CPUID						// code bytes = 0fh,  0a2h
			mov		RegEAX, eax
		}

		if (!(RegEAX & 0x80000000))		// no functions > 0x80000000 ?
			return false;				//we don't have any extended features, quit
		else
			_asm
			{
				mov     eax, 0x80000001		// CPUID ext. function 0x80000001
				CPUID                       // EDX contains extended feature flags
				mov		RegEDX, edx			// extended features returned in edx
			}

   	}
	catch(...)					// catch everything
	{
		return false;
	}

	if (RegEDX & 0x80000000) 	// bit 31 indicates presence of 3DNow! technology
	{
		try
		{
			//DB 0Fh, 0Eh			// try executing the 3DNow! instruction "femms"
			_asm _emit 0x0f;
			_asm _emit 0x0e;
		}
		catch(...) { return false; }
	}
   	else
		return false;

	return true;
#else
	static bool warning = true;
	if (warning)
	{
		cl_info(0, "CL_System::detect_3dnow() not implemented under unix yet.");
		warning = false;
	}
	return false;
#endif
}
