/*
	$Id: resourceoptions.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#include <API/Core/Resources/resource_manager.h>
#include <API/Core/Resources/resourceoption.h>
#include <API/Core/Resources/resourceoptions.h>

#include <strstream>

CL_ResourceOptions::CL_ResourceOptions(CL_ResourceManager *_parent)
{
	parent = _parent;
}

CL_ResourceOptions::~CL_ResourceOptions()
{
	for (
		std::list<CL_ResourceOption*>::iterator it = options.begin();
		it != options.end();
		it++)
	{
		delete (*it);
	}
}

void CL_ResourceOptions::add(CL_ResourceOption *option)
{
	options.push_back(option);
}

bool CL_ResourceOptions::exists(std::string option)
{
//	option.to_lower();

	for (
		std::list<CL_ResourceOption*>::iterator it = options.begin();
		it != options.end();
		it++)
	{
		if ((*it)->get_name() == option) return true;
	}
	return false;
}

std::string CL_ResourceOptions::get_value(std::string option)
{
//	option.to_lower();

	for (
		std::list<CL_ResourceOption*>::iterator it = options.begin();
		it != options.end();
		it++)
	{
		if ((*it)->get_name() == option) return (*it)->get_value();
	}
	return "";
}

CL_ResourceOption *CL_ResourceOptions::get_option(std::string option)
{
//	option.to_lower();

	for (
		std::list<CL_ResourceOption*>::iterator it = options.begin();
		it != options.end();
		it++)
	{
		if ((*it)->get_name() == option) return (*it);
	}
	return NULL;
}

std::list<CL_ResourceOption*> *CL_ResourceOptions::get_options() 
{
	return &options;
}
