/*
	$Id: network_win32.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"

#ifdef USE_NETWORK

#include <iostream>

#include <windows.h>
#include <process.h>

#include "API/Core/Network/network.h"
#include "API/Core/System/cl_assert.h"

#include "Core/Network/Generic/network_generic.h"
//#include "Core/Network/Generic/TransportLayer/network_delivery_packets.h"

#include "network_delivery_win32.h"
#include "network_delivery_winsocket.h"
#include "network_win32.h"

CL_Network_DX *CL_Network_DX::instance = NULL;
CL_Network_Generic *CL_Network_DX::network = NULL;

CL_Network_DX::CL_Network_DX()
{
	std::cout << "Initializing network" << std::endl;
	instance = this;

	WORD winsock_version = MAKEWORD( 2, 0 ); 
	WSADATA wsaData;
	int err = WSAStartup(winsock_version, &wsaData);
	cl_assert(err == 0);

	char name[100];
	gethostname(name, 100);

	HOSTENT *ent = gethostbyname(name);

	unsigned long local_ip = *((unsigned long *) *ent->h_addr_list);

	network = new CL_Network_Generic(new CL_Connections_Win32);
}

CL_Network_DX::~CL_Network_DX()
{
	std::cout << "Deinitializing network" << std::endl;
	delete network;
	network = NULL;
}

#endif // USE_NETWORK