/*
	$Id: inputsource_memory.cpp,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#include "Core/precomp.h"
#include <API/Core/System/error.h>
#include <API/Core/System/clanstring.h>
#include <API/Core/IOData/inputsource.h>
#include <API/Core/IOData/inputsource_memory.h>
#include <API/Core/IOData/inputsource_provider.h>
#include <Core/IOData/Generic/datafile_inputprovider.h>

CL_InputSource_Memory::CL_InputSource_Memory(std::string data)
{
	m_data = data;
	m_pos = 0;
}

CL_InputSource_Memory::~CL_InputSource_Memory()
{
}

void CL_InputSource_Memory::set_system_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_InputSource_Memory::set_big_endian_mode()
{
	cl_assert(false); // not implemented yet.
}

void CL_InputSource_Memory::set_little_endian_mode()
{
	cl_assert(false); // not implemented yet.
}

int CL_InputSource_Memory::read_int32()
{
	cl_assert(m_pos+sizeof(int) <= m_data.size());

	int a = *((int *)(m_data.data()+m_pos));
	m_pos += sizeof(int);
	return a;
}

unsigned int CL_InputSource_Memory::read_uint32()
{
	cl_assert(m_pos+sizeof(unsigned int) <= m_data.size());

	unsigned int a = *((unsigned int *)(m_data.data()+m_pos));
	m_pos += sizeof(unsigned int);
	return a;
}

short CL_InputSource_Memory::read_short16()
{
	cl_assert(m_pos+sizeof(short) <= m_data.size());

	short a = *((short *)(m_data.data()+m_pos));
	m_pos += sizeof(short);
	return a;
}

unsigned short CL_InputSource_Memory::read_ushort16()
{
	cl_assert(m_pos+sizeof(unsigned short) <= m_data.size());

	unsigned short a = *((unsigned short *)(m_data.data()+m_pos));
	m_pos += sizeof(unsigned short);
	return a;
}

char CL_InputSource_Memory::read_char8()
{
	cl_assert(m_pos+1 <= m_data.size());
	return ((char *) m_data.data())[m_pos++];
}

unsigned char CL_InputSource_Memory::read_uchar8()
{
	cl_assert(m_pos+1 <= m_data.size());
	return m_data[m_pos++];
}

bool CL_InputSource_Memory::read_bool()
{
	cl_assert(m_pos+sizeof(bool) <= m_data.size());

	bool a = *((bool *)(m_data.data()+m_pos));
	m_pos += sizeof(bool);
	return a;
}

float CL_InputSource_Memory::read_float32()
{
	cl_assert(m_pos+sizeof(float) <= m_data.size());

	float a = *((float *)(m_data.data()+m_pos));
	m_pos += sizeof(float);
	return a;
}

int CL_InputSource_Memory::read(void *data, int size)
{
	cl_assert(m_pos+size <= m_data.size());
	
	memcpy(data, m_data.data()+m_pos, size);
	m_pos += size;

	return size;
}

void CL_InputSource_Memory::open()
{
	m_pos = 0;
}

void CL_InputSource_Memory::close()
{
}

CL_InputSource *CL_InputSource_Memory::clone() const
{
	return new CL_InputSource_Memory(m_data);
}

int CL_InputSource_Memory::tell() const
{
	return m_pos;
}

void CL_InputSource_Memory::seek(int pos, SeekEnum seek_type)
{
	switch (seek_type)
	{
	case seek_set:
		m_pos = pos;
		break;
	
	case seek_cur:
		m_pos += pos;
		break;
	
	case seek_end:
		m_pos = m_data.size()+pos;
		break;
	
	default: // invalid seek type!
		cl_assert(false);
	}
}

int CL_InputSource_Memory::size() const
{
	return m_data.size();
}

std::string CL_InputSource_Memory::read_string()
{
	int size = read_int32();
	CL_String str((char *) (m_data.data()+m_pos), size);
	m_pos += size;
	return str;
}

void CL_InputSource_Memory::push_position()
{
	cl_assert(false); // not implemented yet.
}

void CL_InputSource_Memory::pop_position()
{
	cl_assert(false); // not implemented yet.
}
