/*
	$Id: displaycard_ptc.h,v 1.1.1.1 2000/04/09 12:18:01 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifdef USE_PTC

#ifndef header_displaycard_ptc
#define header_displaycard_ptc

#include "Core/Display/Generic/displaycard_generic.h"

#ifndef WIN32
#include "Core/Display/X11/display_xwindow.h"
#else
#include <ptc/ptc.h>
#endif

#include "API/Core/Display/display.h"
#include "API/Core/Display/palette.h"
#include "API/Core/Display/target.h"

#include "API/Core/System/cl_assert.h"

class CL_Target_PTC;

class CL_DisplayCard_PTC
#ifndef WIN32
: public CL_XWindow_CompatibleCard
#else
: public CL_DisplayCard_Generic
#endif
{
public:
	CL_DisplayCard_PTC(int card_no);
	virtual ~CL_DisplayCard_PTC();
	
#ifndef WIN32	
	// CL_XWindow_CompatibleCard:
	// --------------------------
	
	virtual Window get_window() { return m_console.getX11Window(); }
	virtual Display *get_display() { return m_console.getX11Display(); }
	virtual Window get_root() { return 0; /*m_console.getX11Root();*/ }
#else
	virtual HWND get_window() {return m_console.window(); }
#endif

	// CL_DisplayCard functions:
	// -------------------------

	virtual void flip_display(bool sync=false);
	virtual void set_palette(CL_Palette *palette);
	virtual CL_Palette *get_palette();
	virtual void set_videomode(int width, int height, int bpp, bool fullscreen, bool allow_resize);
	virtual bool is_initialized();
	
	virtual std::string get_name() { return "OpenPTC Display"; }
	virtual int get_total_memory() { return -1; }
	virtual const std::list<CL_VidMode*> &get_videomodes();

	// CL_DisplayCard_Generic functions:
	// ---------------------------------
	virtual CL_Target *get_target();
	virtual CL_Target *get_frontbuffer();

private:
	CL_Palette m_palette;
	bool m_initialized;
	
	Console m_console;
	CL_Target_PTC *m_target;
};

class CL_Target_PTC : public CL_Target
{
public:
	CL_Target_PTC(Console *console, CL_Palette *pal)
	{
		m_console = console;
		m_pal = pal;
		m_lock_ref = 0;
	}

	virtual void lock()
	{
		m_lock_ref++;
		if (m_lock_ref > 1) return;
		
		m_lock_ptr = m_console->lock();
	}

	virtual void unlock()
	{
		m_lock_ref--;
		cl_assert(m_lock_ref >= 0);

		if (m_lock_ref == 0) m_console->unlock();
	}

	virtual void *get_data() const
	{
		return m_lock_ptr;
	}

	virtual unsigned int get_width() const { return m_console->width(); }
	virtual unsigned int get_height() const { return m_console->height(); }
	virtual unsigned int get_pitch() const { return m_console->pitch(); }

	virtual unsigned int get_depth() const
	{
		Format format = m_console->format();
		return format.bits();
	}
	
	virtual unsigned int get_red_mask() const
	{
		Format format = m_console->format();
		return format.r();
	}

	virtual unsigned int get_green_mask() const
	{
		Format format = m_console->format();
		return format.g();
	}

	virtual unsigned int get_blue_mask() const
	{
		Format format = m_console->format();
		return format.b();
	}

	virtual unsigned int get_alpha_mask() const
	{
		Format format = m_console->format();
		return format.a();
	}

	virtual CL_Palette *get_palette() const
	{
		return m_pal;
	}

	virtual unsigned int get_num_frames() const { return 1; }
	virtual bool is_indexed() const { return false; }

private:
	CL_Palette *m_pal;
	Console *m_console;
	int m_lock_ref;
	void *m_lock_ptr;
};

#ifdef WIN32

class CL_Display_PTC : public CL_Display
{
public:
	CL_Display_PTC(int options);
	virtual ~CL_Display_PTC();

	static CL_DisplayCard_PTC *cur_card;
};

#endif

#endif

#endif
