#ifndef header_mousecursorprovider_generic
#define header_mousecursorprovider_generic

#include "API/Core/Display/mousecursor_provider.h"
#include "API/Core/Display/surfaceprovider.h"


class CL_MouseCursorProvider_Generic : public CL_MouseCursorProvider
{
public:
	CL_MouseCursorProvider_Generic(
		CL_SurfaceProvider *provider,
		bool delete_provider=true,
		bool animate=true,
		const std::vector<int> *frame_delays=NULL);
	virtual ~CL_MouseCursorProvider_Generic();

	virtual CL_SurfaceProvider *get_surface_provider();
	virtual bool is_animated();
	virtual int get_frame_delay(unsigned int frame_number);

private:
	CL_SurfaceProvider *m_surface_provider;
	bool m_delete_provider;
	bool m_animated;
	std::vector<int> m_frame_delays;
};

#endif