
#include "Core/precomp.h"
#include <API/Core/System/error.h>
#include <API/Core/IOData/inputsource.h>
#include <API/Core/IOData/inputsource_provider.h>
#include <API/Core/IOData/outputsource.h>
#include <API/Core/Resources/resource.h>
#include <API/Core/Resources/resource_manager.h>
#include <API/Core/System/clanstring.h>
#include <Core/Resources/resource_manager_file.h>

#include "datafile_compiler.h"
#include "datafile_writer.h"

#include <stdio.h>

int datafile_main(int argc, char **argv)
{
	std::cout << std::endl << "ClanLib Datafile Compiler" << std::endl << std::endl;

	bool found_inputfile = false, found_outputfile = false;
	bool use_scriptfilename = false;

  	CL_String input_file("");
	CL_String output_file("");
	CL_String parameter("");

	for( int arg=1; arg < argc; arg++ )
	{
		parameter = argv[arg];

		// find out what parameter it is
		if( parameter=="--use_scriptfilename" )
			use_scriptfilename = true;

		else // must be filename
		{
			if( found_inputfile ) // must be outputfile name
			{
				output_file = parameter;
				found_outputfile = true;
			}
			else // must be inputfile name
			{
				input_file = parameter;
				found_inputfile = true;
			}
		}	
	}			
			
	if ( !found_inputfile || !found_outputfile )
	{
		std::cout << "Syntax: " << argv[0] << " <input_resource.scr> <output_datafile.dat>" << std::endl << std::endl;
		return 1;
	}

	try
	{
		std::cout << "Input file: " << input_file << ", output file: " << output_file << std::endl;
		CL_ResourceManager *manager = CL_ResourceManager::create(input_file, NULL, true);

		std::list<std::string> *resource_list = manager->get_all_resources();

		OutputSourceProvider_Datafile output(output_file.get_string());

		// Write the config-file to the datafile
		{
			// open the section with either input_file or default_scriptfile_id
			CL_OutputSource *config_osource;

			if( use_scriptfilename )
			{
				config_osource = output.open_source(input_file);
				std::cout << "Using " << input_file << " as sectionname for scriptfile." << std::endl;
			}
			else // use default_scriptfile_id for id
			{
				config_osource = output.open_source(default_scriptfile_id);
//				std::cout << "Using " << default_scriptfile_id << " as sectionname for scriptfile." << endl;
			}
	
			CL_InputSourceProvider *file_provider = CL_InputSourceProvider::create_file_provider("");
			CL_InputSource *config_file = file_provider->open_source(input_file);

			int total_size = config_file->size();
			char *config_file_data = new char[total_size];
			config_file->read(config_file_data, total_size);
			config_osource->write(config_file_data, total_size);

			delete file_provider;
			delete config_file;
			delete config_osource;
		}
	
		for (
			std::list<std::string>::iterator it = resource_list->begin();
			it != resource_list->end();
			it++)
		{
			CL_OutputSource *osource = output.open_source((*it).c_str());

			CL_Resource *res = manager->get_resource(*it);
			if (res != NULL)
			{
				std::cout << "Writing resource '" << it->c_str() << "'" << std::endl;
				res->serialize_save(osource);
			}
			delete osource;
		}
		delete resource_list;
		delete manager;
	}
	catch (CL_Error err)
	{
		std::cout << "Error occured: " << err.message.c_str() << std::endl;
		
		remove (output_file.get_string());
	}

	return 0;
}
