/*
	 $Id: core.h,v 1.3 2000/04/28 23:24:59 mbn Exp $

	 ------------------------------------------------------------------------
	 ClanLib, the platform independent game SDK.

	 This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	 version 2. See COPYING for details.

	 For a total list of contributers see CREDITS.

	 ------------------------------------------------------------------------
*/

#ifndef header_core
#define header_core

#define CL_VERSION(x,y,z)	( (x << 16) | (y << 8) | (z) )
#define CL_CURRENT_VERSION	CL_VERSION(0,4,4)
#define CL_VERSION_STRING "0.4.4"
#define CL_RELEASE_NAME "We need more developers"

#ifdef WIN32
#pragma warning( disable : 4786)
#endif

#include "Core/Display/display.h"
#include "Core/Display/vidmode.h"
#include "Core/Display/displaycard.h"
#include "Core/Display/surfacepriority.h"
#include "Core/Display/surface.h"
#include "Core/Display/palette.h"
#include "Core/Display/pixelformat.h"
#include "Core/Display/surfaceprovider.h"
#include "Core/Display/res_surface.h"
#include "Core/Display/mousecursor.h"
#include "Core/Display/mousecursor_provider.h"
#include "Core/Display/display_events.h"

#include "Core/SurfaceProviders/generic_surfaceprovider.h"
#include "Core/SurfaceProviders/provider_convpoly.h"
#include "Core/SurfaceProviders/provider_convpoly_basics.h"
#include "Core/SurfaceProviders/provider_empty.h"
#include "Core/SurfaceProviders/provider_fli.h"
#include "Core/SurfaceProviders/provider_pcx.h"
#include "Core/SurfaceProviders/provider_bmp.h"
#include "Core/SurfaceProviders/provider_ppm.h"
#include "Core/SurfaceProviders/provider_targa.h"
#include "Core/SurfaceProviders/canvas.h"
#include "Core/SurfaceProviders/sprite.h"
#include "Core/SurfaceProviders/sprite2.h"
#include "Core/SurfaceProviders/sprite_subarray_provider.h"
#include "Core/SurfaceProviders/sprite_subsection_provider.h"
#include "Core/SurfaceProviders/surface_manager.h"

#include "Core/Sound/sound.h"
#include "Core/Sound/soundformat.h"
#include "Core/Sound/static_soundprovider.h"
#include "Core/Sound/stream_soundprovider.h"
#include "Core/Sound/soundbuffer_session.h"
#include "Core/Sound/soundbuffer.h"
#include "Core/Sound/cd_audio.h"

#include "Core/SoundProviders/static_provider_wave.h"
#include "Core/SoundProviders/static_provider_raw.h"
#include "Core/SoundProviders/stream_provider_wave.h"
#include "Core/SoundProviders/stream_provider_raw.h"

#include "Core/Input/input.h"
#include "Core/Input/inputbutton.h"
#include "Core/Input/inputaxis.h"
#include "Core/Input/inputhat.h"
#include "Core/Input/inputcursor.h"
#include "Core/Input/key.h"
#include "Core/Input/inputbuffer.h"
#include "Core/Input/inputdevice.h"
#include "Core/Input/keyboard.h"
#include "Core/Input/mouse.h"
#include "Core/Input/inputbutton_basic.h"
#include "Core/Input/inputbutton_group.h"
#include "Core/Input/inputaxis_basic.h"
#include "Core/Input/inputaxis_group.h"
#include "Core/Input/inputbutton_to_axis_analog.h"
#include "Core/Input/inputbutton_to_axis_digital.h"

#include "Core/Network/network.h"
#include "Core/Network/netcomputer.h"
#include "Core/Network/netgroup.h"
#include "Core/Network/netmessage.h"
#include "Core/Network/netgame.h"

#include "Core/NetObjects/netobject.h"
#include "Core/NetObjects/netobject_controller.h"
#include "Core/NetObjects/netobject_creator.h"

#include "Core/System/setupcore.h"
#include "Core/System/clanapp.h"
#include "Core/System/keep_alive.h"
#include "Core/System/system.h"
#include "Core/System/cl_assert.h"
#include "Core/System/error.h"
#include "Core/System/thread.h"
#include "Core/System/mutex.h"
#include "Core/System/clanstring.h"
#include "Core/System/types.h"

#include "Core/IOData/cl_endian.h"
#include "Core/IOData/inputsource.h"
#include "Core/IOData/inputsource_provider.h"
#include "Core/IOData/inputsource_memory.h"
#include "Core/IOData/outputsource.h"
#include "Core/IOData/outputsource_provider.h"
#include "Core/IOData/outputsource_memory.h"

#include "Core/Resources/resource_manager.h"
#include "Core/Resources/resource_manager_net.h"
#include "Core/Resources/resourcetype.h"
#include "Core/Resources/resource.h"
#include "Core/Resources/resourceoptions.h"
#include "Core/Resources/resourceoption.h"
#include "Core/Resources/resourcetype_boolean.h"
#include "Core/Resources/resourcetype_integer.h"
#include "Core/Resources/resourcetype_string.h"

#include "Core/Font/font.h"
#include "Core/Font/font_description.h"

#include "Core/Math/cl_vector.h"
#include "Core/Math/bezier.h"
#include "Core/Math/math.h"

#endif
