/*
	$Id: cl_gpoint.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

#ifndef CL_GPOINT_H
#define CL_GPOINT_H

#include <iostream>
///
class CL_GPoint
{
 public:
  ///
  CL_GPoint() : x(0), y(0) {;}
  ///
  CL_GPoint(int x_, int y_) : x(x_), y(y_) {;}
  
  CL_GPoint& operator+=(const CL_GPoint& p)
    {  x += p.x; y += p.y;  return *this; }
  ///
  CL_GPoint& operator-=(const CL_GPoint& p)
    {  x -= p.x; y -= p.y;  return *this; }

  ///
  ~CL_GPoint() {};
  ///
  CL_GPoint operator+(const CL_GPoint& q)
  { return CL_GPoint(x - q.x, y - q.y); }
  ///
  CL_GPoint operator-(const CL_GPoint& q)
  { return CL_GPoint(x - q.x, y - q.y); }
//  friend CL_GPoint operator-(const CL_GPoint& p, const CL_GPoint& q)
//    { return CL_GPoint(p.x - q.x, p.y - q.y); }
  ///
  friend bool operator==(const CL_GPoint &p, const CL_GPoint &q)
    { return (p.x == q.x) && (p.y == q.y); };
  ///
  friend bool operator<=(const CL_GPoint &p, const CL_GPoint &q)
    { return (p.x <= q.x) && (p.y <= q.y); };
  ///
  friend bool operator>=(const CL_GPoint &p, const CL_GPoint &q)
    { return (p.x >= q.x) && (p.y >= q.y); };
  ///
  friend bool operator<(const CL_GPoint &p, const CL_GPoint &q)
    { return (p.x < q.x) && (p.y < q.y); };
  ///
  friend bool operator>(const CL_GPoint &p, const CL_GPoint &q)
    { return (p.x > q.x) && (p.y > q.y); };
  ///
  friend std::ostream& operator<<(std::ostream& s, const CL_GPoint& p)
    {
      s << "(" << p.x << ":" << p.y << ")";
      return s;
    }  
  ///
  int x;
  ///
  int y;

};
/*
inline CL_GPoint CL_GPoint::operator+(const CL_GPoint& p, const CL_GPoint& q)
    { return CL_GPoint(p.x - q.x, p.y - q.y); }
inline CL_GPoint CL_GPoint::operator-(const CL_GPoint& p, const CL_GPoint& q)
    { return CL_GPoint(p.x - q.x, p.y - q.y); }
*/
#endif

