/*
	$Id: eventchain.h,v 1.1.1.1 2000/04/09 12:18:00 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="System"

#ifndef header_eventchain
#define header_eventchain

#include "../../stl.h"

template <class T> 
class CL_EventChain
//: Generic event chain template.
// <p>Event chains are used to route an event to an event listener.</p>
{
public:
	void push_back(T event)
	{
		chain.push_back(event);
	}

	void insert(const std::string &name, T event)
	{
		for (
		std::list<T>::iterator it = chain.begin();
		it != chain.end();
		it++)
	{
			if ((*it)->get_name() == name)
			{
			 	chain.insert(
					it,
					event);

				return;
			}
		}
		chain.push_back(event);
	}

	void remove(T event)
	{
		chain.remove(event);
	}

	void remove(const std::string &name)
	{
		for (
			std::list<T>::iterator it = chain.begin();
			it != chain.end();
			it++)
		{
			if ((*it)->get_name() == name)
			{
				chain.remove(*it);

			}
		}
	}

protected:
	std::list<T> chain;
};

class CL_Event
//: Generic event class.
{
public:
	CL_Event() { chain_name = "default"; }
	virtual ~CL_Event() { return; }

	const std::string &get_chain_name() const { return chain_name; }   
	void set_chain_name(const std::string &name) { chain_name = name; }

private:
	std::string chain_name;
};

#endif
