#ifndef header_cd_audio
#define header_cd_audio

//! component="Sound"

class CL_CDDrive
//: CD drive audio interface.
// <p>Use this class to control the CDROM drive in your computer.</p>
{
public:
	virtual ~CL_CDDrive() { ; }

	virtual bool init()=0;
	// Call this one to initialize the cd drive.

	virtual std::string get_drive_path()=0;
	// Get the path of the CD drive. (what is this, starch?)

	virtual std::string get_cd_name()=0;
	// Get the name of the CD.

	virtual int get_num_tracks()=0;
	// Get the number of tracks available on the cd.

	virtual bool is_playing()=0;
	// Returns true if the CD drive is playing.
	
	virtual int get_cur_track()=0;
	// Returns the current track.

	virtual int get_cur_frame()=0;
	// Returns the current frame on the track.

	virtual bool play_tracks(int track, int end_track=0)=0;
	// Play from track 'track' til track 'end_track'.
	//!param: track - Begin track.
	//!param: end_track - End track.

	virtual bool play_frames(int frame, int end_frame=0)=0;
	// Play from frame 'frame' to 'end_frame'.
	//!param: frame - Begin frame.
	//!param: end_frame - End frame.

	virtual bool play_track(int track)=0;
	// Play track 'track'. Returns true if successful.

	virtual void stop()=0;
	// Stop playing.

	virtual void pause()=0;
	// Pause the playback.

	virtual void resume()=0;
	// Resume the playback.
};

class CL_CDAudio
//: CD Audio interface.
{
public:
	static void init_cdaudio();
	// Initialize the list of available cd drives.

	static std::vector<CL_CDDrive *> cd_drives;
	// List of CD drives available.
};

#endif