/*
	$Id: resourceoption.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Resources"

#ifndef header_resourceoption
#define header_resourceoption

#include "../../stl.h"

class CL_ResourceOption
{
public:
	CL_ResourceOption(std::string _name, std::string _value)
	{
		name = _name;
		value = _value;
		has_value = true;
		multiple_values = false;
		values = NULL;
	}

	CL_ResourceOption(std::string _name, std::list<std::string> *_values)
	{
		name = _name;
		values = _values;
		value = (values->empty() == false) ? (values->front()) : std::string("");
		multiple_values = true;
		has_value = true;
	}

	CL_ResourceOption(std::string _name)
	{
		name = _name;
		has_value = false;
		multiple_values = false;
		values = NULL;
	}

	virtual ~CL_ResourceOption()
	{
		if (values != NULL) delete values;
	}

	bool multi_valued() { return multiple_values; }
	std::list<std::string> *get_all_values() { return values; }

	std::string get_name() { return name; }
	std::string get_value()
	{
		if (has_value) return value;
		else return std::string("NO VALUE");
	}
	
private:
	std::string name;
	std::string value;
	std::list<std::string> *values;
	bool has_value;
	bool multiple_values;
};

#endif
