/*
	$Id: resource.h,v 1.1.1.1 2000/04/09 12:17:59 mbn Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//! component="Resources"

#ifndef header_resource
#define header_resource

#include "../../stl.h"
#include "../IOData/outputsource.h"

class CL_Resource
//: Interface representing a resource in the resource manager.
// <p>All resources available in the resource manager is an instance
// of this class. The purpose of the class is to load and unload the resource,
// and if a datafile is being built, it is also used to save it.</p>
// <p>The resource manager uses instances of CL_ResourceType to create
// CL_Resource'es.</p>
// <p>To get more information on how to use create your own version of this
// class, please see the overview documentation.</p>
{
public:
	CL_Resource(std::string type, std::string name);
	virtual ~CL_Resource();

	virtual const std::string &get_type() const { return type; }
	virtual const std::string &get_name() const { return name; }

	virtual void load()=0;
	virtual void unload()=0;
	virtual int get_load_count()=0;

	virtual void serialize_save(CL_OutputSource *output)=0;

private:
	std::string type;
	std::string name;
};

#endif
