#include <ClanLib/core.h>
#include <ClanLib/gl.h>

#define width 640
#define height 480

class GLApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "SmallOpenGL"; }
	

	virtual int main(int, char **)
	{
		try
		{
			CL_Display::set_videomode(width, height, 16);

			
			while (CL_Keyboard::get_keycode(CL_Keyboard::KEY_ESCAPE) == false)
			{
				glViewport(0, 0, width, height);			// Reset The Current Viewport And Perspective Transformation

				glMatrixMode(GL_PROJECTION);
				glLoadIdentity();

				gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,100.0f);
				glMatrixMode(GL_MODELVIEW);
				
				
				
				glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
				glLoadIdentity();									// Reset The View

				glTranslatef(-1.5f,0.0f,-6.0f);						// Move Into The Screen

				glBegin(GL_POLYGON);								// Start Drawing A Polygon
				glColor3f(1.0f,0.0f,0.0f);							// Set Top Point Of Polygon To Red
				glVertex3f( 0.0f, 1.0f, 0.0f);						// First Point Of The Polygon (Triangle)
				glColor3f(0.0f,1.0f,0.0f);							// Set Left Point Of Polygon To Green
				glVertex3f(-1.0f,-1.0f, 0.0f);						// Second Point Of The Polygon
				glColor3f(0.0f,0.0f,1.0f);							// Set Right Point Of Polygon To Blue
				glVertex3f( 1.0f,-1.0f, 0.0f);						// Third Point Of The Polygon
				glEnd();											// Done Drawing The Polygon

				glTranslatef(3.0f,0.0f,0.0f);						// Move Right Three Units

				glColor3f(0.8f,0.0f,1.0f);							// Set The Color To A Nice Blue Shade
				glBegin(GL_QUADS);									// Start Drawing A Quad
				glVertex3f(-1.0f, 1.0f, 0.0f);						// Top Left Of The Quad
				glVertex3f( 1.0f, 1.0f, 0.0f);						// Top Right Of The Quad
				glVertex3f( 1.0f,-1.0f, 0.0f);						// Bottom Right Of The Quad
				glColor3f(1.f,0.5f,0.1f);							//Set one point of the QUADS To a Color
				glVertex3f(-1.0f,-1.0f, 0.0f);						// Bottom Left Of The Quad
				glEnd();
			
				GLenum error;
				while ((error = glGetError()) != GL_NO_ERROR)
					cout << gluErrorString(error) << endl;

				
				CL_Display::flip_display();
				CL_System::keep_alive();

				//CL_Display::clear_display();
			}

		}
				
	
	
	
	catch (CL_Error err)
	{
		cout << "Exception caught: " << err.message.c_str() << endl;
		return -1;
	}

	return 0;
	}
	
	
} app;
