/*
	Init display example.
*/

#include <ClanLib/core.h>

class InitDisplayApp : public CL_ClanApplication
{
public:
	virtual char *get_title() { return "InitDisplay application"; }

	virtual void init_modules()
	{
		CL_SetupCore::init();
	}

	virtual void deinit_modules()
	{
		CL_SetupCore::deinit();
	}

	virtual int main(int, char **)
	{
		CL_SetupCore::init_display();

		try
		{
			// Set mode: 640x480 16 bpp
			CL_Display::set_videomode(640, 480, 16, false);
		
			// Loop until the user hits escape:
			while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
			{
				// Clear display with random colors:
/*				CL_Display::clear_display(
					(rand()%100)/100.0f,  // red component
					(rand()%100)/100.0f,  // green component
					(rand()%100)/100.0f); // blue component
*/
				CL_Display::clear_display(0,0,0, 1);
				CL_Display::draw_line(rand()%2000-1000,rand()%2000-1000,rand()%2000-1000,rand()%2000-1000,0,0,0,0);
				// Flip front and backbuffer. This makes the changes visible:
				CL_Display::flip_display();
			
				// Update keyboard input and handle system events:
				CL_System::keep_alive();
			}
		}
		catch (CL_Error err)
		{
			std::cout << "Error occoured: " << err.message.c_str() << std::endl;
			return 1;
		}

		return 0;
	}
} app;
