#include "cp_types.h"
#include "cp_proto.h"

/* write triples of x,y,z, of eucl data on circle of p. 
filename should already have complete path. */

int writeeucldata(struct p_data *p,char *filename)
{
  int i,node;
  double e_rad,s_rad;
  complex h_center,e_center;
  struct R_data *pR_ptr;
  FILE *fp;
  
  if (!p->status || (node=p->nodecount)<=0) return 0;
  pR_ptr=p->packR_ptr;
  if (strlen(filename)<=NAME_MAX && (fp=fopen(filename,"w"))!=NULL)
    {
      fprintf(fp,
	      "CHECKCOUNT: %d\n\nGEOMETRY: euclidean\n\nRADII:\n",
	      node);
      if (p->hes<0)
	{
	  for (i=1;i<=node;i++)
	    {
	      h_center=pR_ptr[i].center;
	      s_rad=pR_ptr[i].rad;
	      h_to_e_data(h_center,s_rad,&e_center,&e_rad);
	      fprintf(fp,"% .10e ",e_rad);
	      if ((i % 5)==0) fprintf(fp,"\n");
	    }
	}
      else if (p->hes==0)
	{
	  for (i=1;i<=node;i++)
	    {
	      fprintf(fp," % .10e ",pR_ptr[i].rad);
	      if ((i % 5)==0) fprintf(fp,"\n");
	    }
	}
      fprintf(fp,"\n\nCENTERS:\n");
      if (p->hes<0)
	{
	  for (i=1;i<=node;i++)
	    {
	      h_center=pR_ptr[i].center;
	      s_rad=pR_ptr[i].rad;
	      h_to_e_data(h_center,s_rad,&e_center,&e_rad);
	      fprintf(fp,"  % .6e % .6e  ",
		      e_center.re,e_center.im);
	      if ((i % 2)==0) fprintf(fp,"\n");
	    }
	}
      else 
	{
	  for (i=1;i<=node;i++)
	    {
	      fprintf(fp,"  % .6e % .6e  ",
		      pR_ptr[i].center.re,pR_ptr[i].center.im);
	      if ((i % 2)==0) fprintf(fp,"\n");
	    }
	}
      fprintf(fp,"\nEND\n");
      fclose(fp);
      return 1;
    }
  else return 0;
} /* writeeucldata */
