#include "cp_head.h"

/* K_data.plot_flag generally indicates if a reasonable value for
a circle center has been computed when a packing is laid out; if not
set, the circle will not be drawn in certain cases, this lets us
override (generally, plot_flag = 0 or 1). */

int set_plot_flags(struct p_data *p,char *datastr)
{
  int i,hits,flag;
  char *nextpoint,*endptr,next[BUFSIZE];
  struct Vertlist *vertlist,*trace;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  nextpoint=datastr;
  if (!grab_next(&nextpoint,next) || !sscanf(next,"%d",&flag))
    return 0;
  if (!(vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
				 &Vlist,&Elist,&Flist,
				 &region,pathlist,pathlength)))
    {
      for (i=1;i<=p->nodecount;i++) pK_ptr[i].plot_flag=flag;
      return 1;
    }
  trace=vertlist;
  while (trace)
    {
      pK_ptr[trace->v].plot_flag=flag;
      trace=trace->next;
    }
  vert_free(&vertlist);
  return 1;
} /* set_plot_flags */
