#include "cp_types.h"
#include "cp_proto.h"

int remove_edge(struct p_data *p,int v1,int v2)
     /* remove a bdry edge. Already checked that v2 is
counterclockwise neighbor of v1 and removal is okay */
{
  int i,v,n,m,*newflower;
  double *newoverlaps=NULL;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
  /* verify data */
  if (v1<1 || v1>p->nodecount || v2<1 || v2>p->nodecount
      || !pK_ptr[v1].bdry_flag || !pK_ptr[v2].bdry_flag
      || (v2!=pK_ptr[v1].flower[0] && v1!=pK_ptr[v2].flower[0]) )
    {
      strcpy(msgbuf,"An appropriate edge was not specified.");
      emsg();
      return 0;
    }
  if (v1==pK_ptr[v2].flower[0]) {n=v1;v1=v2;v2=n;}
  if (pK_ptr[v1].num<2 || pK_ptr[v2].num<2 
      || pK_ptr[pK_ptr[v1].flower[1]].bdry_flag )
    {
      strcpy(msgbuf,"An appropriate edge was not specified.");
      emsg();
      return 0;
    }
  /* fix up v1 */
  newflower=(int *)calloc((size_t)(pK_ptr[v1].num),sizeof(int));
  if (p->overlap_status)
    newoverlaps=(double *)calloc((size_t)(pK_ptr[v1].num),
				 sizeof(double));
  for (i=1;i<=pK_ptr[v1].num;i++)
    {
      newflower[i-1]=pK_ptr[v1].flower[i];
      if (p->overlap_status)
	newoverlaps[i-1]=pK_ptr[v1].overlaps[i];
    }
  free(pK_ptr[v1].flower);
  pK_ptr[v1].flower=newflower;
  if (p->overlap_status)
    {
      free(pK_ptr[v1].overlaps);
      pK_ptr[v1].overlaps=newoverlaps;
    }
  pK_ptr[v1].num--;
  pK_ptr[pK_ptr[v1].flower[0]].bdry_flag=1;
  pR_ptr[v1].aim=-1;

  /* fix up v2 */
  newflower=(int *)calloc((size_t)(pK_ptr[v2].num),sizeof(int));
  if (p->overlap_status)
    newoverlaps=(double *)calloc((size_t)(pK_ptr[v2].num),
				 sizeof(double));
  for (i=0;i<pK_ptr[v2].num;i++)
    {
      newflower[i]=pK_ptr[v2].flower[i];
      if (p->overlap_status)
	newoverlaps[i]=pK_ptr[v2].overlaps[i];
    }
  free(pK_ptr[v2].flower);
  pK_ptr[v2].flower=newflower;
  if (p->overlap_status)
    {
      free(pK_ptr[v2].overlaps);
      pK_ptr[v2].overlaps=newoverlaps;
    }
  pK_ptr[v2].num--;
  pR_ptr[v2].aim=-1;

  /* fix up common neighbor v */
  v=pK_ptr[v1].flower[0];
  newflower=(int *)calloc((size_t)(pK_ptr[v].num),sizeof(int));
  if (p->overlap_status)
    newoverlaps=(double *)calloc((size_t)(pK_ptr[v].num),
				 sizeof(double));
  n=nghb(p,v,v2);
  m=pK_ptr[v].num;
  for (i=n;i<=m;i++)
    {
      newflower[i-n]=pK_ptr[v].flower[i];
      if (p->overlap_status)
	newoverlaps[i-n]=pK_ptr[v].overlaps[i];
    }
  for (i=1;i<n;i++)
    {
      newflower[m-n+i]=pK_ptr[v].flower[i];
      if (p->overlap_status)
	newoverlaps[m-n+i]=pK_ptr[v].overlaps[i];
    }
  pK_ptr[v].num--;
  free(pK_ptr[v].flower);
  pK_ptr[v].flower=newflower;
  if (p->overlap_status)
    {
      free(pK_ptr[v].overlaps);
      pK_ptr[v].overlaps=newoverlaps;
    }
  pR_ptr[v].aim=-1;

  /* redo pack combinatorics */
  complex_count(p,0);
  facedraworder(p,0);
  return 1;
} /* remove_edge */
