#include "cp_types.h"
#include "cp_proto.h"
#include "cp_post.h"

/* Process 'datastr' of given commands for putting objects in
   postscript file. Various '-o' commands open an output file
   either with explicitly specified name or using 'filename'.
   Other commands add to file once it's opened. File pointer FP
   is passed back. */

char next[BUFSIZE];

int print_call(FILE **FP,struct p_data *p,char *filename,
	       char *datastr,char *user_name,char *Message,
	       char *print_cmd)
{
	int count=0,ecol,col,fcol;
	int dflag,fflag,eflag=1,nflag,cflag,indx;
	int k,j,vert,i,hits,front,v,w,length=0;
	double dotsize,r;
	char *nextpoint,*endptr,buff[256],name[NAME_MAX];
	struct Vertlist *vertlist=NULL,*trace,*facelist=NULL,*vlist;
	struct Edgelist *edgelist=NULL,*track;
	struct RedList *rtrace;
	complex ctr;
	FILE *fp,*sysfp;
	struct Pathlist *ptrace;
	
	fp=*FP;
	nextpoint=datastr;
	strncpy(name,filename,NAME_MAX-1);
	if (!grab_next(&nextpoint,next) || next[0]!='-') return 0;
	switch (fill_mode)
	 {
		case 0: {graylevel=.5;break;/* grey */}
		case 1: {graylevel=1;break; /* white */}
		case 2: {graylevel=0;break; /* black */}
	 }
	ps_linewidth=(1+2*(line_thick-1))*PS_UNIT_LINEWIDTH;
	do
	 {
for (i=strlen(next);i<10;i++) next[i]='\0'; /* clear old info */
if (next[0]!='-') return count;
if (next[1]=='o') /* opening postscript file */
  {
    buff[0]='\0';

    /* check for explicitly specified name */
    endptr=nextpoint; /* may need to reestablish */
    if (!grab_next(&nextpoint,name) || name[0]=='-' || name[0]=='"')
      /* no name specified */
      {
	nextpoint=endptr;
	strncpy(name,filename,NAME_MAX-1);
      }
    /* name now = name of the postscript file */
    if (next[2]=='a') /* append at end of file */
      {
	count += open_psfile(p,3,"\0",FP,name,
			     user_name,Message);
      }
    else if (next[2]=='s') /* going to stdout */
      {
	count += open_psfile(p,0,"\0",FP,"/tmp/dummy.ps",
			     user_name,Message);
      }
    else if (next[2]=='i') /* insert after quoted text */
      {
	int length=strlen(nextpoint);
	int quote1=0,quote2=0;
	while (quote1<length && nextpoint[quote1]!='"') quote1++;
	buff[0]='\0';
	if (quote1<length)
	  {
	    quote2=quote1+1;
	    while (quote2<length && nextpoint[quote2]!='"') quote2++;
	    if (quote2<length && (length=(quote2-quote1-1))>0) 
	      /* found string */
	      { 
		strncpy(buff,nextpoint+quote1+1,length);
		buff[length]='\0';
	      }
	    nextpoint += length+3;
	  }
	count += open_psfile(p,2,buff,FP,name,
			     user_name,Message);
      }
    else count += open_psfile(p,1,"\0",FP,name,
			      user_name,Message);
    if (next[2]=='s') fp=stdout;
    else fp=*FP;
  }
else if (next[1]=='x') /* closing postscript file */
  {
    close_psfile(FP);
    if ((*FP)!=stdout)
      {
	if (next[2]=='l') /* send to printer */
	  {
	    strcpy(buff,print_cmd);
	    strcat(buff," ");
	    strcat(buff,name);
	    sysfp=popen("/bin/sh","w");
	    fprintf(sysfp,"%s\n",buff);
	    pclose(sysfp);
	    printf("Have sent `%s' to the printer.",name);
	  }
	else if (next[2]=='g') /* launch ghostview */
	  {
	    sysfp=popen("/bin/sh","w");
	    
	    fprintf(sysfp," ghostview %s &\n",name);
	    pclose(sysfp);
	  }
      }
  }
else if (fp==NULL || ftell(fp)<=0) /* file not open */
  {
    sprintf(msgbuf,"Check whether file has been opened.");
    emsg();
    break;
  }
else if (next[1]=='l') /* reset linewidth (default to ps_linewidth) */
  {
    stripsp(nextpoint);
    if (*nextpoint!='-' && grab_next(&nextpoint,next) 
	&& sscanf(next,"%d",&i) && i>=0 && i<=15)
      fprintf(fp,"%f ourlinewidth\n",(double)(i*PS_UNIT_LINEWIDTH));
    else fprintf(fp,"%f ourlinewidth\n",ps_linewidth);
    count++;
  }
else if (next[1]=='u') /* unit circle (standard small width) */
  {
    fprintf(fp,"gs %f ourlinewidth ",PS_UNIT_LINEWIDTH);
    if (p->hes>0) post_equator(fp,p->screen);
    else {ctr.re=ctr.im=0.0;post_cir(fp,1.0,ctr,0,FG_COLOR,FG_COLOR);}
    fprintf(fp," gr \n");
    count++;
  }
else if (next[1]=='c') /* post circles */
  {
    cflag=1;
    if (strstr(next+2,"c")) cflag += 8;
    if (strstr(next,"n")) cflag += 32;
    if (strstr(next,"bg")) cflag += 4;
    if (strstr(next,"f")) /* filled faces */
      {
	cflag += 2; /* fill (note: fg/bg imply fill also) */
	if (strstr(next,"bg")) cflag += 4;  /* fill with background */
	else if (strstr(next,"fg"));
	else cflag += 16; /* use recorded color for fill */
      }
    ecol=col=FG_COLOR;
 
    /* listed circles (note unit circle not automatic) */
    if ((vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL)
      {
	nextpoint=endptr;
	trace=vertlist;
	do
	  {
	    vert=trace->v;
	    if (cflag & 16) col=p->packK_ptr[vert].color;
	    if (cflag & 8) 
	      {
		ecol=p->packK_ptr[vert].color;
		if (ecol>=bc_min && ecol<=bc_max) ecol +=bc_offset;
	      }
	    count += post_any_circle(fp,p,vert,cflag,ecol,col);
	    trace=trace->next;
	  } while (trace!=NULL);
	vert_free(&vertlist);
      }
    else /* default to all and put in unit circle */
      {
	if (p->hes<0) 
	  {
	    fprintf(fp,"gs %f ourlinewidth ",PS_UNIT_LINEWIDTH);
	    ctr.re=ctr.im=0.0;
	    post_cir(fp,1.0,ctr,0,FG_COLOR,FG_COLOR);
	    fprintf(fp," gr \n");
	  }
	for (vert=1;vert<=p->nodecount;vert++) /* default to all */
	  {
	    if (cflag & 16) col=p->packK_ptr[vert].color;
	    if (cflag & 8)
	      {
		ecol=p->packK_ptr[vert].color;
		if (ecol>=bc_min && ecol<=bc_max) ecol +=bc_offset;
	      }
	    count+=post_any_circle(fp,p,vert,cflag,ecol,col);
	  }
      }
  }
else if (next[1]=='d') /* post small 'mark' at center of circle. */
 {
   dotsize=(0.015)*(p->screen->box.ry-p->screen->box.ly); 
   if (strstr(next,"c")) dflag=1; /* color? */
   else dflag=0;
   if ((vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
		 &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL)
     {
       nextpoint=endptr;
       trace=vertlist;
       do 
	 {
	   vert=trace->v;
	   count += post_any_dot(fp,p,vert,dotsize,dflag,1);
	   trace=trace->next;
	 } 
       while (trace!=NULL);
       vert_free(&vertlist);
     }
   else for (i=1;i<=p->nodecount;i++) /* default to all */
     {
       count += post_any_dot(fp,p,i,dotsize,dflag,1);
     }
 }
else if (next[1]=='C' || next[1]=='B')
/* draw all circles or circles/faces, recomputed in drawing order */
  {
    if (strstr(next,"c")) cflag=fflag=8; /* color object borders */
    else cflag=fflag=0;
    if (strstr(next,"f")) {cflag += 2;fflag += 2;} /* filled */
    if (strstr(next,"bg")) {cflag += 6;fflag += 6;} /* fill with background */
    else if (strstr(next,"fg"));
    else if (cflag & 2) {cflag += 16;fflag += 16;}
    cflag += 1; /* always want circles */
    if (next[1]=='B') fflag += 1; /* also faces */
    if (strstr(next,"n")) {cflag += 32;fflag += 32;} /* labels */
    stripsp(nextpoint);
    if (*nextpoint=='r') /* want just red circles/faces */
      {
	/* if B, then red faces first */
	if ((fflag & 1)
	    && (facelist=Face_link_parse(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL)
	  {
	    nextpoint=endptr;
	    count += post_facelist(fp,p,fflag,&facelist,1,0);
	  }
	else nextpoint++;

	/* now the circles: here use data in redfaces by segment */
	vert=0;
	for (i=1;p->edge_pair[i].edge;i++) 
	  {
	    /* first (corner) circle black */
	    rtrace=p->edge_pair[i].edge;
	    fcol=ecol=FG_COLOR; /* corner circles black */
	    if (rtrace->next->face==rtrace->prev->face
		&& p->edge_pair[i].edge_indx!=rtrace->v_flag)
	      /* blue face, second edge; circle center from
		 prev face */
	      {
		ctr=rtrace->prev->center;
		r=rtrace->prev->rad;
		if (cflag & 32) vert=p->faces[rtrace->prev->face].
		  vert[rtrace->prev->v_flag];
		post_any_circle_data(fp,p->screen,p->hes,r,ctr,
		  cflag,ecol,fcol,vert);
	      }
	    else
	      {
		ctr=rtrace->center;
		r=rtrace->rad;
		if (cflag & 32) 
		  vert=p->faces[rtrace->face].vert[rtrace->v_flag];
		post_any_circle_data(fp,p->screen,p->hes,r,ctr,
		  cflag,ecol,fcol,vert);
	      }
	    /* now keep going until end */
	    fcol=ecol=p->edge_pair[i].color;
	    if (rtrace->next->face==rtrace->prev->face
		&& (indx=p->edge_pair[i].edge_indx)==rtrace->v_flag)
	      /* blue, just did first edge; increment indx */
	      indx=(indx+1) % 3;
	    else
	      {
		rtrace=rtrace->next_edge;
		indx=(nghb_tri(p,rtrace->prev->face,rtrace->face)+2) % 3;
	      }
	    while (!(rtrace->corner_flag[indx] & 2))
	      {
		 if (rtrace->next->face==rtrace->prev->face
		     && p->edge_pair[i].edge_indx!=rtrace->v_flag)
		   /* blue face, second edge */
		   {
		     ctr=rtrace->prev->center;
		     r=rtrace->rad;
		     if (cflag & 32) vert=p->faces[rtrace->prev->face].
		       vert[rtrace->prev->v_flag];
		     post_any_circle_data(fp,p->screen,p->hes,r,ctr,
		       cflag,ecol,fcol,vert);
		   }
		 else
		   {
		     ctr=rtrace->center;
		     r=rtrace->rad;
		     if (cflag & 32) 
		       vert=p->faces[rtrace->face].vert[rtrace->v_flag];
		     post_any_circle_data(fp,p->screen,p->hes,r,ctr,
		       cflag,ecol,fcol,vert);
		   }
		 if (rtrace->next->face==rtrace->prev->face
		     && (indx=p->edge_pair[i].edge_indx)==rtrace->v_flag)
		   /* blue, just did first edge; increment indx */
		   indx=(indx+1) % 3;
		 else
		   {
		     rtrace=rtrace->next_edge;
		     indx=(nghb_tri(p,rtrace->prev->face,rtrace->face)+2) % 3;
		   }	 
	      } /* end of while */
	    /* last (corner) circle black */
	    fcol=ecol=FG_COLOR; /* corner circles black */
	    if (rtrace->next->face==rtrace->prev->face
		&& p->edge_pair[i].edge_indx!=rtrace->v_flag)
	      /* blue face, second edge; circle center from
		 prev face */
	      {
		ctr=rtrace->prev->center;
		r=rtrace->prev->rad;
		if (cflag & 32) vert=p->faces[rtrace->prev->face].
		  vert[rtrace->prev->v_flag];
		post_any_circle_data(fp,p->screen,p->hes,r,ctr,
		  cflag,ecol,fcol,vert);
	      }
	    else
	      {
		ctr=rtrace->center;
		r=rtrace->rad;
		if (cflag & 32) 
		  vert=p->faces[rtrace->face].vert[rtrace->v_flag];
		post_any_circle_data(fp,p->screen,p->hes,r,ctr,
		  cflag,ecol,fcol,vert);
	      }
	  } /* end of for loop through segments */
      } /* end of drawing just red */

    /* fixup? update parallel to cp_screen.c */

    count += post_in_order(fp,p,cflag,fflag,0);
  }  /* finished with circle cases */

else if (next[1]=='m') /* set 'mark' symbol */
  post_shape(fp,next[2]);

else if (next[1]=='e') /* draw edges */
  {
    if (strstr(next,"c")) eflag=9;
    ecol=FG_COLOR;
    if (strstr(next+2,"e") 
	&& (vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL) 
         /* hex extended edges; NOTE: disregard plot_flags. */
      {
	nextpoint=endptr;
	trace=vertlist;
	while (trace && (v=trace->v)
	       && trace->next && (w=trace->next->v)) /* get pairs */
	  {
	    trace=trace->next;
	    if ((vlist=extended_edge_verts(p,v,w,256))!=NULL)
	      {
		count += post_any_polygon(fp,p,vlist,(eflag & !2),ecol,ecol);
	      }
	    vert_free(&vlist);
	  }
	vert_free(&vertlist);
      }
    else if ((edgelist=Node_pair_link(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))
	     !=NULL)
      {
	nextpoint=endptr;
	track=edgelist;
	do {
	  if (p->packK_ptr[track->v].plot_flag 
	      && p->packK_ptr[track->w].plot_flag)
	    count += post_any_geo(fp,p,
	      p->packR_ptr[track->v].center,
	      p->packR_ptr[track->w].center,eflag,ecol);
	  track=track->next;
	} while (track!=NULL);
	edge_free(&edgelist);
      }
  } /* finished with edges */
else if (next[1]=='f' || next[1]=='F') /* draw faces */
  {
    ecol=col=FG_COLOR;
    cflag=0;
    if (strstr(next,"c")) fflag=9; /* color object borders */
    else fflag=1;
    if (strstr(next,"n")) fflag += 32; /* labels */
    if (strstr(next+2,"f")) /* want filled faces*/
      {
	fflag += 2; /* fill (note: fg/bg imply fill also) */
	if (strstr(next,"bg")) fflag += 4;  /* fill with background */
	else if (strstr(next,"fg"));
	else fflag += 16; /* default, use recorded color */
      }
    if (fflag & 4) col=BG_COLOR;
    if ((facelist=Face_link_parse(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL)
      {
	nextpoint=endptr;
	if (next[1]=='F')  /* locate faces as they're drawn */ 
	  count += post_facelist(fp,p,fflag,&facelist,1,0);
	else count += post_facelist(fp,p,fflag,&facelist,0,0);
      }
    else if (next[1]=='F') /* use draworder, but recompute centers */
      count += post_in_order(fp,p,cflag,fflag,0);
    else for (k=1;k<=p->facecount;k++)
      {
	if (fflag & 16) col=p->faces[k].color;
	if (fflag & 8)
	  {
	    ecol=p->faces[k].color;
	    if (ecol>=bc_min && ecol<=bc_max) ecol +=bc_offset;
	  }
	count+=post_any_face(fp,p,k,fflag,ecol,col);
      }
  } /* finished with faces */
else if (next[1]=='R' 
  && p->edge_pair[2].edge) /* specified paired edges in non-simply 
			       connected cases; draw thick & in color */
  {
    nflag=dflag=0;
    if (strstr(next,"n")) nflag=1; /* label segments */
    if (strstr(next,"p")) dflag=1; /* draw mated pairs */
    length=0;
    while (p->edge_pair[length+1].edge) length++;
    /* fixup: should we know number of segments from euler/etc? */
    /* fixup: set thicker line */
    if ((vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL)
      {
	nextpoint=endptr;
	trace=vertlist;
	while (trace && (j=trace->v)>0 && j <= length)
	  {
	    count += post_bdry_seg(fp,p,j,9,p->edge_pair[j].color);
	    if (dflag && (i=index_of_paired_edge(p,j)))
	      post_bdry_seg(fp,p,i,9,p->edge_pair[i].color);
	    trace=trace->next;
	  }
	if (nflag)
	  {
	    trace=vertlist;
	    while (trace && (j=trace->v)>0 && j <= length)
	      {
		post_bdry_seg_num(fp,p,j);
		if (dflag && (i=index_of_paired_edge(p,j)))
		  post_bdry_seg_num(fp,p,i);
		trace=trace->next;
	      }
	  }
      }
    else for (i=1;p->edge_pair[i].edge;i++)
      post_bdry_seg(fp,p,i,9,p->edge_pair[i].color);
    vert_free(&vertlist);
    /* fixup: reset original line thickness */
  }
else if (next[1]=='s') /* closed polygon through vertlist */
  {
    col=FG_COLOR;
    eflag=1;
    if (strstr(next,"bg")) {col=BG_COLOR;eflag += 6;}
    else if (strstr(next,"fg")) eflag += 2;
    else if (strstr(next,"f")) eflag += 18;

    if ((vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL)
      {
	trace=vertlist;
	while(trace && trace->next) {trace=trace->next;} /* find end? */
	if (trace && trace->v!=vertlist->v) /* repeat first vert at end */
	  {
	    trace->next=(struct Vertlist *)
	      calloc((size_t)1,sizeof(struct Vertlist));
	    trace->next->v=vertlist->v;
	  }	    
	nextpoint=endptr;
	trace=vertlist;
	count += post_any_polygon(fp,p,vertlist,eflag,FG_COLOR,col);
	vert_free(&vertlist);
      }
  }
else if (next[1]=='n') /* labels */
  {
    if (next[2]=='f') /* faces */
      {
	if ((facelist=Face_link_parse(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL)
	  {
	    nextpoint=endptr;
	    trace=facelist;
	    do {
	      count += post_face_label(fp,p,trace->v);
	      trace=trace->next;
	    } while (trace!=NULL);
	    vert_free(&facelist);
	  }
	else for (k=1;k<=p->facecount;k++) 
	  count += post_face_label(fp,p,k);
      }
    else if (next[2]=='c') /* circles */
      {
	if ((vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
		  &Vlist,&Elist,&Flist,&region,pathlist,pathlength))!=NULL)
	  {
	    nextpoint=endptr;
	    trace=vertlist;
	    do {
	      count += post_cir_label(fp,p,trace->v);
	      trace=trace->next;
	    } while (trace!=NULL);
	    vert_free(&vertlist);
	  }
	else for (k=1;k<=p->nodecount;k++) 
	  count += post_cir_label(fp,p,k);
      }
    else if ( 			/* 'l' or 'z' */
      (
        (
	  next[2]=='z'  		/* given point */
		&& grab_next(&nextpoint,next)
		   && sscanf(next,"%lf",&(ctr.re))
		&& grab_next(&nextpoint,next)
		   && sscanf(next,"%lf",&(ctr.im))
		&& !(i=0)
	)
	||
	(
	  next[2]=='l'  		/* or center of circle */
	  && (i=grab_one_vert(p,&nextpoint)))
      )
      && grab_next(&nextpoint,next) 
      && strlen(strncpy(buff,next,32))!=0 
      )
		/* put string either at cent of i or at given ctr. */
      {
	if (i>0) ctr=p->packR_ptr[i].center;
	strcat(buff,"\0");
	if (p->hes>0) 
	  {
	    ctr=ss_view(p->screen,ctr,1,&front);
	    if (front)
	      {
		ctr=s_pt_to_visual_plane(ctr);
		fprintf(fp,"%f %f m (%s) sh\nn\n",
			ctr.re,ctr.im,buff);
		count++;
	      }
	  }
	else
	  {
	    fprintf(fp,"%f %f m (%s) sh\nn\n",
		    ctr.re,ctr.im,buff);
	    count++;
	  }
      }
 } /* finished with labels */
else if (next[1]=='g') /* print path */
 {
	if (pathlength<4) break;
	fprintf(fp,"n\n");
	fprintf(fp,"%f %f m\n",pathlist->x,pathlist->y);
	ptrace=pathlist;
	while ((ptrace=ptrace->next)!=NULL) 
		fprintf(fp,"%f %f l\n",ptrace->x,ptrace->y);
	fprintf(fp,"cp\ns\n");
 }
else if (next[1]=='r' && next[2]=='c' && (rtrace=p->redfaces)) 
  /* test: draw circles from redlist data */
  {
    ecol=col=FG_COLOR;
    cflag=1;
    if (strstr(next+3,"c")) cflag += 8; /* color object borders */
    if (strstr(next,"n")) cflag += 32; /* labels */
    if (strstr(next,"f")) cflag += 2; /* want filled circles */
    if (strstr(next,"bg")) cflag += 6;  /* fill with background */
    else if (strstr(next,"fg"));
    else if (cflag & 2) cflag += 16; /* default, use recorded color */
    if (cflag & 4) col=BG_COLOR;

    i=0;
    while (rtrace!=p->redfaces || !(i++))
      {
	vert=p->faces[rtrace->face].vert[rtrace->v_flag];
	if (cflag & 16) col=p->packK_ptr[vert].color;
	if (cflag & 8)
	  {
	    ecol=p->packK_ptr[vert].color;
	    if (ecol>=bc_min && ecol<=bc_max) ecol +=bc_offset;
	  }
	count += post_any_circle_data(fp,p->screen,p->hes,
	  rtrace->rad,rtrace->center,cflag,ecol,col,vert);
	rtrace=rtrace->next;
      }
  } 
else if (next[1]=='t') /* print caption (filename by default); must be
	last command of this print_call. */
 {
	if (strlen(strncpy(buff,nextpoint,255))==0)
		strcpy(buff,p->file_name);
	count += post_caption(fp,buff);
	return count;
 } 
	 } /* end of do */
	while (nextpoint!=NULL && grab_next(&nextpoint,next) );
	return count;		
} /* print_call */

