#include "cp_types.h"
#include "cp_proto.h"

/* compute ang sum, allow overlaps. Radii/overlaps incompatible, 
flag gets set, results are not reliable. */

int h_anglesum_overlap(struct p_data *p,int i,double s,double *c,int *flag)
{
  int k,j2,j1;
  double s1,s2,o1,o2,o3;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  *c=0;
  *flag=0;
  if (s<=0) return 1; /* infinite radius at vertex of interest */
  j2=pK_ptr[i].flower[0];
  s2=pR_ptr[j2].rad;
  if (!p->overlap_status)
    for (k=1;k<=pK_ptr[i].num;k++)
      {
	s1=s2;
	s2=pR_ptr[pK_ptr[i].flower[k]].rad;
	*c+=acos(h_comp_cos(s,s1,s2));
      }
  else
    {
      o2=pK_ptr[i].overlaps[0];
      for (k=1;k<=pK_ptr[i].num;k++)
	{
	  s1=s2;
	  o1=o2;
	  j1=j2;
	  j2=pK_ptr[i].flower[k];
	  s2=pR_ptr[j2].rad;
	  o2=pK_ptr[i].overlaps[k];
	  o3=pK_ptr[j1].overlaps[nghb(p,j1,j2)];
	  *c+=acos(h_cos_overlap(s,s1,s2,o3,o2,o1,flag));
	}
    }
  return 1;
} /* h_anglesum_overlap */
