#include "cp_types.h"
#include "cp_proto.h"

int geom_to_e_pack_convert(struct p_data *p)
     /* convert p to eucl data. */
{
  int i,wflag=0;
  double r;
  struct R_data *pR_ptr;
  struct RedList *trace;

  pR_ptr=p->packR_ptr;
  if (p->hes==0) return 1;  /* eucl already */
  else if (p->hes<0) /* hyp */
    {
      for (i=1;i<=p->nodecount;i++)
	h_to_e_data(pR_ptr[i].center,pR_ptr[i].rad,
		    &pR_ptr[i].center,&pR_ptr[i].rad);
      if ((trace=p->redfaces))
	while (trace!=p->redfaces || !(wflag++))
	  {
	    i=p->faces[trace->face].vert[trace->v_flag];
	    h_to_e_data(trace->center,trace->rad,
			&(trace->center),&(trace->rad));
	    trace=trace->next;
	  }
    }
  else if (p->hes>0)
    {
      for (i=1;i<=p->nodecount;i++)
	{
	  s_to_e_data(pR_ptr[i].center,pR_ptr[i].rad,
		      &pR_ptr[i].center,&r);
	  pR_ptr[i].rad=fabs(r);
	}
      if ((trace=p->redfaces))
	while (trace!=p->redfaces || !(wflag++))
	  {
	    i=p->faces[trace->face].vert[trace->v_flag];
	    s_to_e_data(trace->center,trace->rad,
			&(trace->center),&r);
	    trace->rad=fabs(r);
	    trace=trace->next;
	  }
    }
  p->hes=0;
  return 1;
} /* geom_to_e_pack_convert */

int geom_to_h_pack_convert(struct p_data *p)
/* takes eucl pack (with eucl centers and radii) and squeezes it to 
unit disc with alpha vertex at origin, then replaces eucl centers 
and radii by hyp centers and s-radii. Spherical goes via eucl. */
{
  int i,wflag=0;
  double m,mx;
  complex cent;
  struct R_data *pR_ptr;
  struct RedList *trace;

  pR_ptr=p->packR_ptr;
  if (p->hes<0) return 1; /* hyp */
  else if (p->hes==0) /* eucl */
    {
      cent=pR_ptr[p->alpha].center;
      mx=pR_ptr[p->alpha].rad;
      for (i=1;i<=p->nodecount;i++) /* translate and
				       determine scaling factor */
	{
	  pR_ptr[i].center=csub(pR_ptr[i].center,cent);
	  m=cAbs(pR_ptr[i].center);
	  if ((m+pR_ptr[i].rad)>mx) mx=m+pR_ptr[i].rad;
	}
      mx *= 1.05; /* shrink slightly from unit circle */
      for (i=1;i<=p->nodecount;i++)
	{
	  pR_ptr[i].center.re /= mx;
	  pR_ptr[i].center.im /= mx;
	  pR_ptr[i].rad /= mx;
	  e_to_h_data(pR_ptr[i].center,
		      pR_ptr[i].rad,&pR_ptr[i].center,&pR_ptr[i].rad);
	}
      if ((trace=p->redfaces)) /* fixup? could be that rad/cent in
				  redface ends up outside unit disc */
	while (trace!=p->redfaces || !(wflag++))
	  {
	    i=p->faces[trace->face].vert[trace->v_flag];
	    trace->center.re /= mx;
	    trace->center.im /= mx;
	    e_to_h_data(trace->center,
			trace->rad,&(trace->center),&(trace->rad));
	    trace=trace->next;
	  } 
    }
  else if (p->hes>0) /* pass sph through eucl */
    {
      geom_to_e_pack_convert(p);
      geom_to_h_pack_convert(p);
    }
  p->hes=-1;
  return 1;
} /* geom_to_h_pack_convert */

int geom_to_s_pack_convert(struct p_data *p)
/* takes eucl or hyp pack to sphere, with alpha vertex at south pole.  */
{
  int i,wflag=0;
  double rad;
  complex ctr;
  struct R_data *pR_ptr;
  struct RedList *trace;

  pR_ptr=p->packR_ptr;
  if (p->hes>0) return 1; /* sph already */
  if (p->hes<0)        /* hyp */
    {
      for (i=1;i<=p->nodecount;i++)
	{
	  h_to_e_data(pR_ptr[i].center,pR_ptr[i].rad,&ctr,&rad);
	  e_to_s_data(ctr,rad,&pR_ptr[i].center,&pR_ptr[i].rad);
	}
      if ((trace=p->redfaces))
	while (trace!=p->redfaces || !(wflag++))
	  {
	    i=p->faces[trace->face].vert[trace->v_flag];
	    h_to_e_data(trace->center,trace->rad,&ctr,&rad);
	    e_to_s_data(ctr,rad,&(trace->center),&(trace->rad));
	    trace=trace->next;
	  }
    }
  else
    {
      for (i=1;i<=p->nodecount;i++)
	e_to_s_data(pR_ptr[i].center,pR_ptr[i].rad,
		    &pR_ptr[i].center,&pR_ptr[i].rad);
      if ((trace=p->redfaces))
	while (trace!=p->redfaces || !(wflag++))
	  {
	    i=p->faces[trace->face].vert[trace->v_flag];
	    e_to_s_data(trace->center,trace->rad,
			&(trace->center),&(trace->rad));
	    trace=trace->next;
	  }
    }
  p->hes=1;
  return 1;
} /* geom_to_s_pack_convert */











