/***************************************************************************
                          sample.h  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SAMPLE_H
#define SAMPLE_H


#include "typedefs.h"
#include "sample_data.h"

/**
  *@author Juan Linietsky
  */

/******************************
 sample.h
 --------

Contains the sample modifiers
and attributes. The actual
tech data of it is contained in
sample_data.h
********************************/

struct Sample {

	string name;
	string filename;

	Sint8  def_volume;
	Sint8  glb_volume;

	bool   def_panning_on;
        Sint8  def_panning;

	Uint8  vibrato_type;
	Uint8  vibrato_speed;
	Uint8  vibrato_depth;
	Uint8  vibrato_rate;

	Sample_Data data;
	
	bool in_use;

	void operator=(Sample r_sample);

        void reset(bool try_to_free_data=true);
	Sample();
	~Sample();
};

#endif
