import dbus
import dbus.service
import dbus.mainloop.glib

class ManagerDbusInterface(dbus.service.Object):
	def __init__(self, bus, obj):
		dbus.service.Object.__init__(self, bus, obj)

		self.on_refreshing_cb = None

	@dbus.service.method("org.tuxfamily.cgmail.ManagerInterface",
				in_signature="sb", out_signature="")
	def set_refreshing(self, account_id, value):
		if self.on_refreshing_cb is not None:
			self.on_refreshing_cb(account_id, value)
	
	def set_on_refreshing_cb(self, cb):
		self.on_refreshing_cb = cb

getting = False

def get_dbus_interface():
	global getting
	if getting: return None

	#return None

	dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
	bus = dbus.SessionBus()
	try:
		obj = bus.get_object("org.tuxfamily.cgmail.Manager", "/Manager")
		iface = dbus.Interface(obj, "org.tuxfamily.cgmail.ManagerInterface")
	except dbus.DBusException:
		getting = False
		return None

	getting = False
	return iface

