#ifndef __UTILS_H
#define __UTILS_H

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "main.h" /* return values */

enum {
	CDW_FILE,
	CDW_DIR
} file_type;


void process_commandline_args(int argc, char *argv[]);
int cdw_locale_init(void);
int zombie_handler_init(void);

int add_to_dic();
void after_event(char *message, int adddic);


/* filesystem utils */
long long dirsize(char **pathtable, int paths);
long long _dirsize(char *dirpath);
int one(const struct dirent *unused);
void load_dir(char *dir, int width, int height);
int check_for_boot_image(void);
int get_home_dir(char **path);
int get_tmp_dir(char **path);
cdw_rv_t is_valid_path(char *fullpath, mode_t permissions, int filetype, struct stat *finfo);
cdw_rv_t get_valid_path(char *fullpath, mode_t permissions, int filetype, int n, char *title, char *prompt);

/* string utils */
char *rtrim(char *str);
char *ltrim(char *str);
char *concat(const char *str, ...);
void my_itoa(int i, char *string);

#endif /* __UTILS_H */
