/*

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qglobal.h>

#if defined(_OS_LINUX_) || defined(Q_OS_LINUX)
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "../linux/VideoDeviceLinux.h"
#endif
#if defined(_OS_WIN32_) || defined(Q_OS_WIN32)
#include "../win32/VideoDeviceWin32.h"
#endif

#include "VideoCollector.h"

CVideoCollector *CVideoCollector::s_pVideoCollector = 0;
#if defined(_OS_WIN32_) || defined(Q_OS_WIN32)
QMap<HWND, CVideoDeviceWin32 *>CVideoCollector::s_HWND2Video;
#endif

CVideoCollector::CVideoCollector()
{
   qDebug("CVideoCollector::VideoCollector()");
}


// private

void CVideoCollector::Scan()
{
#if defined(_OS_WIN32_) || defined(Q_OS_WIN32)
   int i;
   CVideoDeviceWin32 *pDev;
   char name[100], version[100];

   for (i = 0; i < 10; i++) {
      if (capGetDriverDescription(i, name ,sizeof(name), version, sizeof(version))) {
qDebug("found videodriver at pos %d: %s, %s", i, name, version);
        pDev = new CVideoDeviceWin32(i);
        if (pDev->IsValid())
          m_Devices.append(pDev);
        else
          delete pDev;
      }
      else
        break;
   }
#endif
#if defined(_OS_LINUX_) || defined(Q_OS_LINUX)
   QString devname;
   struct stat devstat;
   int i;
   CVideoDeviceLinux *v;

   /* Argh. This is the second time Qt bites me in /dev: IT WON'T BLOODY
      LIST DEVICE INODES!!! So back to plain old sprintf().
    */

   for (i = 0; i < 64; i++) {
      devname.sprintf("/dev/video%d", i);
      if (stat(devname, &devstat) == 0) {
        if (!S_ISLNK(devstat.st_mode)) {
          v = new CVideoDeviceLinux(devname);
          if (!v->IsValid()) { // The class detects if this is a valid device
            delete v;
            v = NULL;
          }
          if (v)
            m_Devices.append(v);
        } // .. if !S_ISLNK
      } // ..if !stat
   } // ..for i
#endif
}



// public

CVideoCollector *CVideoCollector::Instance()
{
   if (s_pVideoCollector == 0) {
     s_pVideoCollector = new CVideoCollector();
     s_pVideoCollector->Scan();
   }
   return s_pVideoCollector;
}


uint CVideoCollector::NumberOfVideoDevices() const
{
   return m_Devices.count();
}

CVideoDevice *CVideoCollector::GetVideoDevice(uint n)
{
   if (n < 0 || n >= m_Devices.count())
     return 0;
   return m_Devices.at(n);
}



#if defined(_OS_WIN32_) || defined(Q_OS_WIN32)

/* These functions are necessary for Windows, since that uses a callback mechanism.
   This is probably the best place to handle this, since CVideoCollector already
   knows about the video-devices present; it dispatches the callbacks to the
   apropriate device.
*/

void CVideoCollector::RegisterDevice(HWND h, CVideoDeviceWin32 *pVideo)
{
   s_HWND2Video[h] = pVideo;

   capSetCallbackOnCapControl (h, CVideoCollector::ControlCallback);
   capSetCallbackOnError      (h, CVideoCollector::ErrorCallback);
   capSetCallbackOnStatus     (h, CVideoCollector::StatusCallback);
   capSetCallbackOnVideoStream(h, CVideoCollector::VideoCallback);
//   capSetCallbackOnYield      (h, CVideoCollector::YieldCallback);
}

void CVideoCollector::UnregisterDevice(HWND h)
{
   if (!s_HWND2Video.contains(h))
     return;

   capSetCallbackOnCapControl (h, NULL);
   capSetCallbackOnError      (h, NULL);
   capSetCallbackOnStatus     (h, NULL);
   capSetCallbackOnVideoStream(h, NULL);
//   capSetCallbackOnYield      (h, NULL);

   s_HWND2Video.remove(h);
}

LRESULT CALLBACK CVideoCollector::ControlCallback(HWND h, int id)
{
   CVideoDeviceWin32 *pVideo;

   pVideo = s_HWND2Video[h];
   if (pVideo == 0)
     return FALSE;

   return pVideo->CallbackControl(id);
}


LRESULT CALLBACK CVideoCollector::ErrorCallback(HWND h, int id, LPTSTR text)
{
   CVideoDeviceWin32 *pVideo;

   pVideo = s_HWND2Video[h];
   if (pVideo == 0)
     return FALSE;

   return pVideo->CallbackError(id, text);
}

LRESULT CALLBACK CVideoCollector::StatusCallback(HWND h, int id, LPTSTR text)
{
   CVideoDeviceWin32 *pVideo;

   pVideo = s_HWND2Video[h];
   if (pVideo == 0)
     return FALSE;

   return pVideo->CallbackStatus(id, text);
}

LRESULT CALLBACK CVideoCollector::VideoCallback(HWND h, LPVIDEOHDR video)
{
   CVideoDeviceWin32 *pVideo;

   pVideo = s_HWND2Video[h];
   if (pVideo == 0)
     return FALSE;

   return pVideo->CallbackVideoStream(video);
}


LRESULT CALLBACK CVideoCollector::YieldCallback(HWND h)
{
   CVideoDeviceWin32 *pVideo;

   pVideo = s_HWND2Video[h];
   if (pVideo == 0)
     return FALSE;

   return pVideo->CallbackYield();
}

#endif
