#ifndef DCTPANEL_HPP
#define DCTPANEL_HPP

#include "CamPanel.h"
#include "CamTile.h"

class CDCTPanel: public CCamPanel
{
   Q_OBJECT
private:
   CCamPanel *pBasePanel;
   bool Inverse;

   bool TilesDefault;
   int tiles_y, tiles_uv;
   CCamTile *pTilesY, *pTilesUV;
  
   int coeff[32];  /* DCT coeffecients */

   void CreateTiles();
  
public:
   CDCTPanel(CCamPanel *base_panel, bool inv,
   	     const char *name = "dct.yuv", 
   	     const char *desc = "DCT conversion");
   ~CDCTPanel();

   void SetTiles(CCamTile *tilesy, CCamTile *tilesuv);

public slots:   
   void UpdatePanel();
   void SetSize(const QSize &ns);
};

#endif
