/*  audiodevs: Abstraction layer for audio hardware & samples
    Copyright (C) 2003-2004 Nemosoft Unv.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    For questions, remarks, patches, etc. for this program, the author can be
    reached at camstream@smcc.demon.nl.
*/
#ifndef AUDIODEVICEMIXER_HPP
#define AUDIODEVICEMIXER_HPP

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qdict.h>
#include <qdom.h>
#include <qgrid.h>
#include <qobject.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qscrollview.h>
#include <qslider.h>
#include <qsocket.h>
#include <qvector.h>
#include <qwidget.h>

#if (QT_VERSION >= 0x030000)
#include <qmutex.h>
#endif

#define ALSA_PCM_NEW_HW_PARAMS_API
#define ALSA_PCM_NEW_SW_PARAMS_API
#include <alsa/asoundlib.h>

class CAudioControlScrollWidget: public QScrollView
{
protected:
   void viewportResizeEvent(QResizeEvent *e);

public:
   QWidget *m_pCanvas;
   QGridLayout *m_pGrid;

   QVector <QButtonGroup> m_CaptureGroups;

   CAudioControlScrollWidget(QWidget *parent = 0, const char *name = 0, WFlags f = 0);

   void SetSize();
};

class CAudioMixerElement: public QObject
{
   Q_OBJECT
private:
   enum ControlType { Unknown, Playback, Capture, PlaybackCapture, Switch, Enumeration };

   ControlType m_SliderType;
   snd_mixer_t *m_pMixer;
   snd_mixer_selem_id_t *m_pSID;

   int m_ChannelMask, m_ChannelCount;
   snd_mixer_selem_channel_id_t m_Channels[SND_MIXER_SCHN_LAST + 1];

   // column 0
   QString m_Name;

   // column 1
   bool m_PlaybackMono;
   bool m_PlaybackSwitch;
   bool m_PlaybackSwitchIsMute;
   bool m_PlaybackVolumeJoined, m_PlaybackSwitchJoined;
   QSlider *m_pPlaybackSlider[SND_MIXER_SCHN_LAST + 1];
   QComboBox *m_pDropdownBox;

   // column 2
   QCheckBox *m_pPlaybackCheckBox;

   // column 3
   bool m_CaptureMono;
   bool m_CaptureSwitch;
   bool m_CaptureVolumeJoined, m_CaptureSwitchJoined;
   bool m_CaptureExclusive;
   int m_CaptureGroup;
   QSlider *m_pCaptureSlider;

   // column 4
   QRadioButton *m_pCaptureRadioButton; // only one of these two is used
   QCheckBox *m_pCaptureCheckBox;


private slots:
   void MovedCaptureVolume(int);
   void MovedPlaybackVolume(int);
   void ChangedEnumerationSelection(int);
   void ToggledSwitch(bool);
   void ToggledCapture(int);

public:
   CAudioMixerElement(snd_mixer_t *mixer, snd_mixer_elem_t *elem, int row, CAudioControlScrollWidget *parent);
   ~CAudioMixerElement();

   const QString &GetName() const { return m_Name; };
   void GetConfiguration(QDomNode &dom_node) const;
   void SetConfiguration(const QDomNode &dom_node) const;

   int GetCaptureGroup() const;

public slots:
   void UpdateFromDevice();

signals:
   void UserClickedSomething();
};




class CAudioControlLinux: public QObject
{
   Q_OBJECT
private:
   QString m_DeviceName;
   snd_mixer_t *m_pMixer;
   unsigned int m_Count;
   QDict<CAudioMixerElement> m_Elements;
   QWidget *m_pMixerWidget;
   CAudioControlScrollWidget *m_pScrollWidget;

   int m_PollFDCount;
   struct pollfd *m_pPollFDs;
   QVector<QSocket> m_Sockets;

private slots:
   void SocketRead();

protected:

public:
   CAudioControlLinux(const char *device);
   ~CAudioControlLinux();

   void GetConfiguration(QDomNode &dom_node) const;
   void SetConfiguration(const QDomNode &dom_node);

public slots:
   void ShowControls();

signals:
   void ForceUpdate(); ///< Connected to MixerElements, to update them all at once

   void UpdateControls(); ///< Emitted when the user changes something in the GUI
};

#endif
