/** 
  \class CRGBShow
  \brief Display RGB image from YUV representation
  
  This class shows a RGB image based on a YUV image.
 */

#include <qglobal.h>
 
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "RGBShow.h"
#include "ccvt.h"

CRGBShow::CRGBShow(CCamPanel *yuv_panel, const char *name, const char *desc)
	: CCamPanel(name, desc, RGB)
{
   pBase = yuv_panel;
   if (pBase == NULL)
     return;
   if (pBase->GetPanelType() != YUV420) {
     pBase = NULL;
     return;
   }
     
   ConnectUsage(pBase);
   ConnectResizes(pBase);
   
   SetSize(pBase->GetImageSize());
}


// public
// public slots

void CRGBShow::UpdatePanel()
{
   uchar *srcy, *srcu, *srcv;
   uchar *dst;

   if (pBase == NULL)
     return;

   dst = ImgRGB.bits();
   srcy = pBase->GetImage(0).bits();
   srcu = pBase->GetImage(1).bits();
   srcv = pBase->GetImage(2).bits();
   
   if (dst == NULL || srcy == NULL || srcu == NULL || srcv == NULL)
     return;

#ifdef HAVE_INTELCPU
#if QT_VERSION >= 200
   ccvt_420p_bgr32(image_w, image_h, srcy, srcu, srcv, dst);
#else
   ccvt_420p_rgb32(image_w, image_h, srcy, srcu, srcv, dst);
#endif
#endif
   emit Updated();
}

