/**********************************************************************

	--- Qt Architect generated file ---

	File: VideoControl.cc
	Last generated: Sat Dec 18 06:37:21 1999

 *********************************************************************/

#include "VideoControl.h"

#include <sys/ioctl.h>

#define Inherited CVideoControlData

CVideoControl::CVideoControl(CVideoDevice *_video, QWidget* parent, const char* name)
	: Inherited( parent, name )
{
   pVideo = _video;
   setCaption("Video Controls");
   GetControl(TRUE);
}


CVideoControl::~CVideoControl()
{
}

// private

void CVideoControl::GetControl(bool First)
{
   // Read settings from cam, set sliders
   if (pVideo == NULL)
     return;

   brightness = pVideo->GetBrightness();
   contrast = pVideo->GetContrast();
   gamma = pVideo->GetWhiteness();
   colour = pVideo->GetColour();

   if (First) {
     org_b = brightness;
     org_o = contrast;
     org_g = gamma;
     org_c = colour;
     if (brightness == 0xffff) Brightness->setEnabled(FALSE); 
     if (contrast   == 0xffff) Contrast->setEnabled(FALSE);
     if (gamma      == 0xffff) Gamma->setEnabled(FALSE);
     if (colour     == 0xffff) Colour->setEnabled(FALSE);
   } 

   /* A disabled control will be stuck to the right hand side */
   Brightness->setValue(brightness >> 8);
   Contrast->setValue(contrast >> 8);
   Gamma->setValue(gamma >> 8);
   Colour->setValue(colour >> 8);
}

// protected

void CVideoControl::ChangedBrightness(int value)
{
   brightness = value << 8;
   pVideo->SetBrightness(brightness);
}

void CVideoControl::ChangedContrast(int value)
{
   contrast = value << 8;
   pVideo->SetContrast(contrast);
}

void CVideoControl::ChangedGamma(int value)
{
   gamma = value << 8;
   pVideo->SetWhiteness(gamma);
}

void CVideoControl::ChangedColour(int value)
{
   colour = value << 8;
   pVideo->SetColour(colour);
}

// public slots

void CVideoControl::RestoreDefaults()
{
   if (org_b != 0xffff) pVideo->SetBrightness(org_b);
   if (org_o != 0xffff) pVideo->SetContrast(org_o);
   if (org_g != 0xffff) pVideo->SetWhiteness(org_g);
   if (org_c != 0xffff) pVideo->SetColour(org_c);
   GetControl();
}

